/*_______________________________________________________________

tc-004.c

Function:  This program demonstrates how to simulate a
sculptured background graphic.

Compatibility:  Supports all graphics adapters and monitors.
The software uses the 640x480 16-color mode if a VGA is
present, the 640x350 16-color mode if an EGA and enhanced
monitor are present, the 640x200 16-color mode if an EGA and
standard monitor are present, and the 320x200 4-color mode
if a CGA or MCGA is present.

Remarks:  By altering two variables in the declarations
module you can try out different color combinations.
The brightness control and the contrast control on your
monitor have a strong effect on the image's appearance.

Copyright 1988 Lee Adams and TAB BOOKS Inc.

_________________________________________________________________


I N C L U D E    F I L E S                                       */

#include <dos.h>                        /* supports the DOS call */
#include <stdio.h>               /* supports the printf function */
#include <graphics.h>         /* supports the graphics functions */

/*_______________________________________________________________


D E C L A R A T I O N S                                          */

void keyboard(void);               /* declare global subroutines */
void quit_pgm(void);
void graphics_setup(void);void coords(void);
void notice (float x, float y);

/*                                      declare global variables */
float sx=0,sy=0,x_res=0,y_res=0,sx1=0,sy1=0,sx2=0,sy2=0;
int C0=0,C1=1,C2=2,C3=3,C4=4,C5=5,C6=6,C7=7,C8=8,C9=9,C10=10,
C11=11,C12=12,C13=13,C14=14,C15=15,mode_flag=0;
int t=1,t1=1;                              /* counters for loops */
float x=52,y=32,x1=52,h1=80,v1=30,h2=81,v2=31,h3=90,v3=35;
int bg=2,shadow=0,hilite=10;

/*_______________________________________________________________


M A I N    R O U T I N E                                         */

main(){
graphics_setup();                     /* establish graphics mode */

bg=C2;shadow=C0;hilite=C10;
setfillstyle(SOLID_FILL,bg);
sx=0;sy=24;coords();sx1=sx;sy1=sy;
sx=639;sy=454;coords();sx2=sx;sy2=sy;
bar(sx1,sy1,sx2,sy2);                                      /* bg */
sx=619;sy=41;coords();moveto(sx,sy);setcolor(hilite);
sx=619;sy=437;coords();lineto(sx,sy);
sx=620;sy=41;coords();moveto(sx,sy);
sx=620;sy=437;coords();lineto(sx,sy);
sx=19;sy=437;coords();lineto(sx,sy);
setcolor(shadow);sx=19;sy=41;coords();lineto(sx,sy);
sx=20;sy=437;coords();moveto(sx,sy);
sx=20;sy=41;coords();lineto(sx,sy);
sx=620;sy=41;coords();lineto(sx,sy);

for (t1=1;t1<=4;t1++){           /* loop for 4 rows of pedestals */
for (t=1;t<=6;t++){       /* nested loop for 6 pedestals per row */
moveto(x,y);setcolor(hilite);lineto(x+h1,y);
setcolor(shadow);moveto(x+h1,y+1);lineto(x+h1,y+v1);
moveto(x+h2,y+1);lineto(x+h2,y+v1);lineto(x,y+v1);
setcolor(hilite);lineto(x,y);moveto(x+1,y+v1);
lineto(x+1,y);x=x+h3;};        /* reposition x for next pedestal */
x=x1;y=y+v3;};                    /* reposition x,y for next row */

setcolor(C7);notice(0,0);                              /* notice */
keyboard();                      /* wait for user to press <Esc> */
quit_pgm();                        /* end the program gracefully */
}
/*_______________________________________________________________


SUBROUTINE: CHECK THE KEYBOARD BUFFER                            */

void keyboard(void){
union u_type {int a;char b[3];} keystroke;
int get_keystroke(void);           /* declare a local subroutine */

do keystroke.a=get_keystroke();
while (keystroke.b[0]!=27);        /* return if <Esc> is pressed */
}

/* LOCAL SUBROUTINE: RETRIEVE ONE KEYSTROKE                      */

int get_keystroke(void){
union REGS regs;regs.h.ah=0;return int86(0x16,&regs,&regs);}

/*_______________________________________________________________


SUBROUTINE: GRACEFUL EXIT FROM THE PROGRAM                       */

void quit_pgm(void){
cleardevice();restorecrtmode();exit(0);}

/*______________________________________________________________


SUBROUTINE: VGA/EGA/CGA/MCGA compatibility module

This subroutine invokes the highest-resolution graphics mode
which is permitted by the hardware.  The 640x480 16-color mode
is established if a VGA is present.  The 640x350 16-color mode
is established if an EGA is being used with an enhanced color
display monitor or a multiscanning monitor.  The 640x200
16-color mode is established if an EGA is being used with a
standard color monitor.  The 320x200 4-color mode is invoked
if a CGA or MCGA is present.                                     */

void graphics_setup(void){
int graphics_adapter,graphics_mode;
detectgraph(&graphics_adapter,&graphics_mode);
if (graphics_adapter==VGA) goto VGA_mode;              /* if VGA */
if (graphics_mode==EGAHI) goto EGA_ECD_mode;   /* if EGA and ECD */
if (graphics_mode==EGALO) goto EGA_SCD_mode;   /* if EGA and SCD */
if (graphics_adapter==CGA) goto CGA_mode;              /* if CGA */
if (graphics_adapter==MCGA) goto MCGA_mode;           /* if MCGA */
goto abort_message;              /* if no VGA, EGA, CGA, or MCGA */

VGA_mode:                     /* establish 640x480 16-color mode */
graphics_adapter=VGA;graphics_mode=VGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=480;mode_flag=1;setcolor(C7);
x=52;y=77;x1=52;h1=80;v1=72;h2=81;v2=73;h3=90;v3=84;
outtextxy(0,472,"640x480 16-color VGA mode.");
outtextxy(160,0,"USING C TO CREATE A SCULPTURED BACKGROUND");
return;

EGA_ECD_mode:                 /* establish 640x350 16-color mode */
graphics_adapter=EGA;graphics_mode=EGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=350;mode_flag=2;setcolor(C7);
x=52;y=56;x1=52;h1=80;v1=53;h2=81;v2=54;h3=90;v3=61;
outtextxy(0,342,"640x350 16-color EGA mode.");
outtextxy(160,0,"USING C TO CREATE A SCULPTURED BACKGROUND");
return;

EGA_SCD_mode:                 /* establish 640x200 16-color mode */
graphics_adapter=EGA;graphics_mode=EGALO;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=200;mode_flag=3;setcolor(C7);
x=52;y=32;x1=52;h1=80;v1=30;h2=81;v2=31;h3=90;v3=35;
outtextxy(0,192,"640x200 16-color EGA mode.");
outtextxy(160,0,"USING C TO CREATE A SCULPTURED BACKGROUND");
return;

CGA_mode:                      /* establish 320x200 4-color mode */
graphics_adapter=CGA;graphics_mode=CGAC3;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=320;y_res=200;C0=0;C2=2;C7=3;C10=3;mode_flag=4;setcolor(C7);
x=26;y=32;x1=26;h1=40;v1=30;h2=41;v2=31;h3=45;v3=35;
outtextxy(0,192,"320x200 4-color CGA mode.");
outtextxy(88,0,"SCULPTURED BACKGROUND");
return;

MCGA_mode:                     /* establish 320x200 4-color mode */
graphics_adapter=MCGA;graphics_mode=MCGAC3;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=320;y_res=200;C0=0;C2=2;C7=3;C10=3;mode_flag=4;setcolor(C7);
x=26;y=32;x1=26;h1=40;v1=30;h2=41;v2=31;h3=45;v3=35;
outtextxy(0,192,"320x200 4-color MCGA mode.");
outtextxy(88,0,"SCULPTURED BACKGROUND");
return;

abort_message:
printf("\n\nUnable to proceed.\n");
printf("Requires VGA, EGA, MCGA, or CGA adapter\n");
printf("   with appropriate monitor.\n");
printf("Please refer to the book.\n\n");
exit(0);
}
/*_______________________________________________________________


SUBROUTINE: coords()

This subroutine accepts sx,sy device-independent display
coordinates and returns sx,sy device-dependent screen
coordinates scaled to fit the 640x480, 640x350, 640x200, or
320x200 screen, depending upon the graphics mode being used.     */

void coords(void){
sx=sx*(x_res/640);sy=sy*(y_res/480);return;}

/*_______________________________________________________________


SUBROUTINE: Copyright Notice

This subroutine displays the standard copyright notice.
If you are typing in this program from the book you can
safely omit this subroutine, provided that you also remove
the instruction "notice()" from the main routine.                */

int copyright[][3]={0x7c00,0x0000,0x0000,0x8231,
0x819c,0x645e,0xba4a,0x4252,0x96d0,0xa231,0x8252,0x955e,0xba4a,
0x43d2,0xf442,0x8231,0x825c,0x945e,0x7c00,0x0000,0x0000};

void notice(float x, float y){
int a,b,c; int t1=0;
for (t1=0;t1<=6;t1++){a=copyright[t1][0];b=copyright[t1][1];
c=copyright[t1][2];
setlinestyle(USERBIT_LINE,a,NORM_WIDTH);
moveto(x,y);lineto(x+15,y);
setlinestyle(USERBIT_LINE,b,NORM_WIDTH);
moveto(x+16,y);lineto(x+31,y);
setlinestyle(USERBIT_LINE,c,NORM_WIDTH);
moveto(x+32,y);lineto(x+47,y);y=y+1;};
setlinestyle(USERBIT_LINE,0xFFFF,NORM_WIDTH);
return;}

/*_______________________________________________________________

End of source code                                               */

