/*_______________________________________________________________

func-007.c

Function:  This program demonstrates the fundamental
algorithms involved in bitblt animation.

Compatibility:  Supports all graphics adapters and monitors.
By default, the software uses the 640x200 2-color mode in
order to animate at 43 frames per second.  However, if you
have a VGA or EGA you can delete one line in the
compatibility subroutine in order to force the program to
use the 640x200 16-color mode (and animate at 11 frames
per second).

Remarks:  The run-time speed of bitblt animation is
inversely proportional to the screen resolution.  Coarser
resolution with fewer available screen colors will yield
quicker bitblt animation (graphic array animation).
Refer to the book for further guidance.

Copyright 1988 Lee Adams and TAB BOOKS Inc.

_________________________________________________________________


I N C L U D E    F I L E S                                       */

#include <stdio.h>               /* supports the printf function */
#include <graphics.h>         /* supports the graphics functions */
#include <process.h>             /* supports the exit() function */
#include <bios.h>            /* supports read of keyboard buffer */
#include <alloc.h>                 /* supports memory allocation */

/*_______________________________________________________________


D E C L A R A T I O N S                                          */

void keyboard(void);void quit_pgm(void);
void notice(float x,float y);void graphics_setup(void);

int t1=1,x1=220,y1=100,x2=270,y2=120,
sx=220,sy=100,sxmove=3,symove=-1,sx1,sy1;
int C0=0,C1=1,C2=2,C3=3,C4=4,C5=5,C6=6,C7=7,C8=8,C9=9,C10=10,
C11=11,C12=12,C13=13,C14=14,C15=15,mode_flag=0;

char far *gr_array1;                 /* pointer to graphic array */

/*_______________________________________________________________


M A I N    R O U T I N E                                         */

main(){
graphics_setup();                     /* establish graphics mode */


/*------------- create and store the graphic array --------------*/

setcolor(C7);circle(x1+25,y1+10,22);
setfillstyle(SOLID_FILL,C4);floodfill(x1+25,y1+10,C7);
gr_array1=(char far*)farmalloc((unsigned long)imagesize(x1,y1,x2,y2));
getimage(x1,y1,x2,y2,gr_array1);
setfillstyle(SOLID_FILL,C0);bar(x1,y1,x2,y2);

/*              ----------------------------------               */

setcolor(C7);rectangle(201,40,439,159);  /* animation boundaries */
notice(0,192);                                         /* notice */
putimage(sx,sy,gr_array1,COPY_PUT);     /* install block graphic */
outtextxy(0,96,"Animation rate:    ");
moveto(0,104);
if (mode_flag==4)
outtext("43 frames per second");        /* if 640x200 2-clr mode */
if (mode_flag==3)
outtext("11 frames per second");       /* if 640x200 16-clr mode */

/*------------------ bitblt animation manager -------------------*/

for (t1=1;t1!=20; ){                 /* animate for endless loop */
if (sx1>=386) sxmove=-3;              /* test for right boundary */
if (sx1<=204) sxmove=3;                /* test for left boundary */
if (sy1>=138) symove=-1;             /* test for bottom boundary */
if (sy1<=41) symove=1;                  /* test for top boundary */
sx1=sx+sxmove;sy1=sy+symove;           /* calculate new position */
putimage(sx1,sy1,gr_array1,COPY_PUT);       /* install new array */
sx=sx1;sy=sy1;                         /* update sx,sy variables */
keyboard();};                   /* check for user keyboard input */

/*                    ------------------------                   */

quit_pgm();}                       /* end the program gracefully */

/*_______________________________________________________________


SUBROUTINE: press any key to quit                                */

void keyboard(void){
if (bioskey(1)==0) return; else quit_pgm();}

/*_______________________________________________________________


SUBROUTINE: GRACEFUL EXIT FROM THE PROGRAM                       */

void quit_pgm(void){
cleardevice();restorecrtmode();exit(0);}

/*______________________________________________________________


SUBROUTINE: VGA/EGA/CGA/MCGA compatibility module                */

void graphics_setup(void){
int graphics_adapter,graphics_mode;
detectgraph(&graphics_adapter,&graphics_mode);

goto CGA_mode; /* If you have a VGA or EGA, you can delete this
line to force the software to use the 640x200 16-color mode
(which runs much slower than the default 640x200 2-color mode).  */

if (graphics_adapter==VGA) goto EGA_SCD_mode;          /* if VGA */
if (graphics_mode==EGAHI) goto EGA_SCD_mode;   /* if EGA and ECD */
if (graphics_mode==EGALO) goto EGA_SCD_mode;   /* if EGA and SCD */
if (graphics_adapter==CGA) goto CGA_mode;              /* if CGA */
if (graphics_adapter==MCGA) goto CGA_mode;            /* if MCGA */
goto abort_message;              /* if no VGA, EGA, CGA, or MCGA */


EGA_SCD_mode:                 /* establish 640x200 16-color mode */
graphics_adapter=EGA;graphics_mode=EGALO;
initgraph(&graphics_adapter,&graphics_mode,"");
mode_flag=3;setcolor(C7);
outtextxy(240,192,"Press any key to quit...");
outtextxy(192,0,"USING C FOR HIGH SPEED ANIMATION");
outtextxy(192,176,"640x200 16-color VGA and EGA mode.");
return;

CGA_mode:                      /* establish 640x200 2-color mode */
graphics_adapter=CGA;graphics_mode=CGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
mode_flag=4;C0=0;C1=1;C2=1;C3=1;C4=1;C5=1,C6=1;C7=1;
C8=1;C9=1;C10=1;C11=1;C12=1;C13=1;C14=1;C15=1;
setcolor(C7);
outtextxy(240,192,"Press any key to quit...");
outtextxy(192,0,"USING C FOR HIGH SPEED ANIMATION");
outtextxy(176,176,"640x200 2-color VGA, EGA, and CGA mode.");
return;

abort_message:
printf("\n\nUnable to proceed.\n");
printf("Requires VGA, EGA, MCGA, or CGA adapter\n");
printf("   with appropriate monitor.\n");
printf("Please refer to the book.\n\n");
exit(0);
}
/*_______________________________________________________________


SUBROUTINE: Copyright Notice

This subroutine displays the standard copyright notice.
If you are typing in this program from the book you can
safely omit this subroutine, provided that you also remove
the instruction "notice()" from the main routine.                */

int copyright[][3]={0x7c00,0x0000,0x0000,0x8231,
0x819c,0x645e,0xba4a,0x4252,0x96d0,0xa231,0x8252,0x955e,0xba4a,
0x43d2,0xf442,0x8231,0x825c,0x945e,0x7c00,0x0000,0x0000};

void notice(float x, float y){
int a,b,c; int t1=0;
for (t1=0;t1<=6;t1++){a=copyright[t1][0];b=copyright[t1][1];
c=copyright[t1][2];
setlinestyle(USERBIT_LINE,a,NORM_WIDTH);
moveto(x,y);lineto(x+15,y);
setlinestyle(USERBIT_LINE,b,NORM_WIDTH);
moveto(x+16,y);lineto(x+31,y);
setlinestyle(USERBIT_LINE,c,NORM_WIDTH);
moveto(x+32,y);lineto(x+47,y);y=y+1;};
setlinestyle(USERBIT_LINE,0xFFFF,NORM_WIDTH);
return;}

/*_______________________________________________________________

End of source code                                               */


