/*_______________________________________________________________

func-005.c

Function:  This program demonstrates the fundamental
algorithms involved in high speed frame animation.

Compatibility:  Supports all graphics adapters and monitors.
The software uses the 640x200 16-color mode if a VGA or an
EGA is present.  The 640x200 2-color mode is used if a
CGA is present.

Remarks:  The 640x200 16-color mode is used with the VGA and
EGA because four graphics pages are required by this animated
program.  If a CGA is present, the extra pages required by
the program are stored in user RAM.

Copyright 1988 Lee Adams and TAB BOOKS Inc.

_________________________________________________________________


I N C L U D E    F I L E S                                       */

#include <stdio.h>               /* supports the printf function */
#include <graphics.h>         /* supports the graphics functions */
#include <process.h>             /* supports the exit() function */
#include <mem.h>                        /* supports memory moves */
#include <bios.h>            /* supports read of keyboard buffer */

/*_______________________________________________________________


D E C L A R A T I O N S                                          */

void keyboard(void);void quit_pgm(void);
void notice(float x,float y);void coords(void);
void graphics_setup(void);void labels(void);void blocks(void);

void animVGAEGA(void);                       /* EGA and VGA only */
void animCGA(void);                                  /* CGA only */
void pagemove(unsigned source,unsigned target);      /* CGA only */

int frame=0,t1=1,t2=2;
float sx,sy;float x_res,y_res;
int C0=0,C1=1,C2=2,C3=3,C4=4,C5=5,C6=6,C7=7,C8=8,C9=9,C10=10,
C11=11,C12=12,C13=13,C14=14,C15=15,mode_flag=0;
char fill_50[]={85,170,85,170,85,170,85,170};

/*_______________________________________________________________


M A I N    R O U T I N E                                         */

main(){
graphics_setup();                     /* establish graphics mode */
setcolor(C7);


if (mode_flag==3) {setvisualpage(0);setactivepage(0);};
cleardevice();
frame=0;                                   /* set the frame flag */
labels();                      /* create the alphanumeric labels */
blocks();                                   /* draw the graphics */
if (mode_flag==4) {pagemove(0xB800,0x8800);}           /* if CGA */

if (mode_flag==3) {setvisualpage(1);setactivepage(1);};
cleardevice();
frame=1;                                   /* set the frame flag */
labels();                      /* create the alphanumeric labels */
blocks();                                   /* draw the graphics */
if (mode_flag==4) {pagemove(0xB800,0x8C00);}           /* if CGA */

if (mode_flag==3) {setvisualpage(2);setactivepage(2);};
cleardevice();
frame=2;                                   /* set the frame flag */
labels();                      /* create the alphanumeric labels */
blocks();                                   /* draw the graphics */
if (mode_flag==4) {pagemove(0xB800,0x9000);}           /* if CGA */

if (mode_flag==3) {setvisualpage(3);setactivepage(3);};
cleardevice();
frame=3;                                   /* set the frame flag */
labels();                      /* create the alphanumeric labels */
blocks();                                   /* draw the graphics */
if (mode_flag==4) {pagemove(0xB800,0x9400);};          /* if CGA */

if (mode_flag==3) {setvisualpage(0);setactivepage(0);};
if (mode_flag==4) {pagemove(0x8800,0xB800);};

for (t1=1;t1<=30000;t1++);             /* pause before animating */
if (mode_flag==3) animVGAEGA();     /* animation for VGA and EGA */
if (mode_flag==4) animCGA();                /* animation for CGA */

quit_pgm();}                       /* end the program gracefully */

/*_______________________________________________________________


SUBROUTINE: frame animation manager for VGA and EGA              */

void animVGAEGA(void){
for (t1=1;t1!=2; ){                 /* animate for endless loop */
setvisualpage(1);for (t2=1;t2<=3000;t2++);
setvisualpage(2);for (t2=1;t2<=3000;t2++);
setvisualpage(3);for (t2=1;t2<=30000;t2++);keyboard();
setvisualpage(2);for (t2=1;t2<=3000;t2++);
setvisualpage(1);for (t2=1;t2<=3000;t2++);
setvisualpage(0);for (t2=1;t2<=10000;t2++);keyboard();};
return;}

/*_______________________________________________________________


SUBROUTINE: frame animation manager for CGA                      */

void animCGA(void){
for (t1=1;t1!=2; ){                  /* animate for endless loop */
pagemove(0x8C00,0xB800);for (t2=1;t2<=3000;t2++);
pagemove(0x9000,0xB800);for (t2=1;t2<=3000;t2++);
pagemove(0x9400,0xB800);for (t2=1;t2<=30000;t2++);keyboard();
pagemove(0x9000,0xB800);for (t2=1;t2<=3000;t2++);
pagemove(0x8C00,0xB800);for (t2=1;t2<=3000;t2++);
pagemove(0x8800,0xB800);for (t2=1;t2<=10000;t2++);keyboard();};
return;}

/*_______________________________________________________________


SUBROUTINE: pagemove for CGA

This subroutine is called during the graphics drawing process
in order to store the frames in user RAM.  This subroutine is
also called during the frame animation process in order to
flip the previously-stored pages onto the CGA display buffer
at B8000 hex.  For serious development work, you would want
to use a short assembly language subroutine instead.             */

void pagemove(unsigned source, unsigned target){
movedata(source,0x0000,target,0x0000,16000);return;}

/*_______________________________________________________________


SUBROUTINE: alphanumeric labels                                  */

void labels(void){
setcolor(C7);moveto(184,192);
if (mode_flag==3) {outtext("640x200 16-color VGA and EGA mode");}
if (mode_flag==4) {outtext("640x200 2-color CGA mode");}
moveto(168,0);
outtext("USING C FOR HIGH SPEED FRAME ANIMATION");
moveto(128,32);
outtext("High speed rotation of a simple geometric shape...");
moveto(232,176);outtext("Press any key to quit.");
moveto(0,96);outtext("Animation rate:");
moveto(0,104);
if (mode_flag==3) outtext("14 frames per second");
if (mode_flag==4) outtext("7 frames per second");
return;}

/*_______________________________________________________________


SUBROUTINE: draw the graphics                                    */

void blocks(void){
if (frame==0) {sx=209;sy=139;coords();moveto(sx,sy);
sx=389;sy=139;coords();lineto(sx,sy);
sx=389;sy=339;coords();lineto(sx,sy);
sx=209;sy=339;coords();lineto(sx,sy);
sx=209;sy=139;coords();lineto(sx,sy);};
if (frame==1) {sx=218;sy=141;coords();moveto(sx,sy);
sx=387;sy=151;coords();lineto(sx,sy);
sx=379;sy=337;coords();lineto(sx,sy);
sx=211;sy=327;coords();lineto(sx,sy);
sx=218;sy=141;coords();lineto(sx,sy);};
if (frame==2) {sx=226;sy=149;coords();moveto(sx,sy);
sx=382;sy=161;coords();lineto(sx,sy);
sx=371;sy=331;coords();lineto(sx,sy);
sx=214;sy=318;coords();lineto(sx,sy);
sx=226;sy=149;coords();lineto(sx,sy);};
if (frame==3) {sx=236;sy=150;coords();moveto(sx,sy);
sx=378;sy=170;coords();lineto(sx,sy);
sx=359;sy=327;coords();lineto(sx,sy);
sx=218;sy=308;coords();lineto(sx,sy);
sx=236;sy=150;coords();lineto(sx,sy);};
if (mode_flag==3) {setfillstyle(SOLID_FILL,C4);};  /* VGA or EGA */
if (mode_flag==4) {setfillpattern(fill_50,C7);};       /* if CGA */
sx=299;sy=239;coords();floodfill(sx,sy,C7);
setcolor(C7);sx=5;sy=460;coords();notice(sx,sy);       /* notice */
return;}

/*_______________________________________________________________


SUBROUTINE: press any key to quit                                */

void keyboard(void){
if (bioskey(1)==0) return; else quit_pgm();}

/*_______________________________________________________________


SUBROUTINE: GRACEFUL EXIT FROM THE PROGRAM                       */

void quit_pgm(void){
if(mode_flag==3) {setvisualpage(0);setactivepage(0);};
cleardevice();restorecrtmode();exit(0);}

/*______________________________________________________________


SUBROUTINE: VGA/EGA/CGA/MCGA compatibility module                */

void graphics_setup(void){
int graphics_adapter,graphics_mode;
detectgraph(&graphics_adapter,&graphics_mode);
if (graphics_adapter==VGA) goto VGA_EGA_mode;          /* if VGA */
if (graphics_mode==EGAHI) goto VGA_EGA_mode;   /* if EGA and ECD */
if (graphics_mode==EGALO) goto VGA_EGA_mode;   /* if EGA and SCD */
if (graphics_adapter==CGA) goto CGA_mode;              /* if CGA */
if (graphics_adapter==MCGA) goto CGA_mode;            /* if MCGA */
goto abort_message;              /* if no VGA, EGA, CGA, or MCGA */

VGA_EGA_mode:                 /* establish 640x200 16-color mode */
graphics_adapter=EGA;graphics_mode=EGALO;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=200;mode_flag=3;
return;

CGA_mode:                      /* establish 640x200 2-color mode */
graphics_adapter=CGA;graphics_mode=CGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=200;mode_flag=4;
C0=0;C1=1;C2=1;C3=1;C4=1;C5=1;C6=1;C7=1;C8=1;C9=1;C10=1;C11=1;
C12=1;C13=1;C14=1;C15=1;return;

abort_message:
printf("\n\nUnable to proceed.\n");
printf("Requires VGA, EGA, MCGA, or CGA adapter\n");
printf("   with appropriate monitor.\n");
printf("Please refer to the book.\n\n");
exit(0);
}
/*_______________________________________________________________


SUBROUTINE: coords()

This subroutine accepts sx,sy device-independent display
coordinates and returns sx,sy device-dependent screen
coordinates scaled to fit the 640x480, 640x350, 640x200, or
320x200 screen, depending upon the graphics mode being used.     */

void coords(void){
sx=sx*(x_res/640);sy=sy*(y_res/480);return;}

/*_______________________________________________________________


SUBROUTINE: Copyright Notice

This subroutine displays the standard copyright notice.
If you are typing in this program from the book you can
safely omit this subroutine, provided that you also remove
the instruction "notice()" from the main routine.                */

int copyright[][3]={0x7c00,0x0000,0x0000,0x8231,
0x819c,0x645e,0xba4a,0x4252,0x96d0,0xa231,0x8252,0x955e,0xba4a,
0x43d2,0xf442,0x8231,0x825c,0x945e,0x7c00,0x0000,0x0000};

void notice(float x, float y){
int a,b,c; int t1=0;
for (t1=0;t1<=6;t1++){a=copyright[t1][0];b=copyright[t1][1];
c=copyright[t1][2];
setlinestyle(USERBIT_LINE,a,NORM_WIDTH);
moveto(x,y);lineto(x+15,y);
setlinestyle(USERBIT_LINE,b,NORM_WIDTH);
moveto(x+16,y);lineto(x+31,y);
setlinestyle(USERBIT_LINE,c,NORM_WIDTH);
moveto(x+32,y);lineto(x+47,y);y=y+1;};
setlinestyle(USERBIT_LINE,0xFFFF,NORM_WIDTH);
return;}

/*_______________________________________________________________

End of source code                                               */

