;       C/MS chip programming example
;
;       Plays middle C note
;
;       Written by JDA of Elastic Force, 1991.
;       Based on not-working piece of code from Creative Labs.
;       (does this work ??)

DOSSEG
.MODEL MEDIUM
.STACK 200h
.CODE

            ; initialize voice 1-6

            MOV DX,221H         ; Address register for channels 1-6
            MOV AL,0            ; start with register address 0

LABEL1:
            OUT DX,AL           ; Select internal register
            MOV AH,DL           ; preserve register address to AH
            DEC DX              ; point to data register, 220h
            SUB AL,AL           ; Zero AL by subtracting it with itself.
            OUT DX,AL           ; Send to port
            INC DX              ; point to address register, 221h
            MOV AL,AH           ; recover register address from AH
            INC AL              ; move to next address
            CMP AL,20H          ; Compare AL with 20h
            JB  Label1          ; If less, jump to LABEL1

            MOV AL,1CH          ; select frequency reset register
            OUT DX,AL           ;   for all channels

            DEC DX              ; Point to data register 220h
            MOV AL,2            ; Register address 2
            OUT DX,AL           ; Reset frequency for voice #1-6

            ;--initial voice#7-12

            MOV DX,223H         ; Address register for channels 7-12
            MOV AL,0            ; Register address 0

LABEL2:     OUT DX,AL           ; Select internal register
            MOV AH,AL           ; Preserve register address to AH
            DEC DX              ; Point to data register 222h
            SUB AL,AL           ; Zero AL
            OUT DX,AL           ; Initialize to 0
            INC DX              ; Point to address register 223h

            MOV AL,AH           ; Recover regs. address from AH
            INC AL              ; Move to next address
            CMP AL,20H          ; Compare AL with 20h
            JB  LABEL2          ; Jump if Below.

            MOV AL,1CH          ; Select frequency reset register
            OUT DX,AL           ;   for all channels
            DEC DX              ; Point to data port 222h
            MOV AL,2
            OUT DX,AL           ; Reset frequency for voice#7-12

;Following codes enable sound for all voices :

            MOV DX,221H         ; Channels 1-6 register port 221h
            MOV AL,1CH          ;   Sound enable register, 1C,
            OUT DX,AL           ; Select sound enable register
            DEC DX              ; Channels 1-6 data port 220h
            MOV AL,1            ; Registers address 1
            OUT DX,AL           ; Select all sound for voice#1-6

            MOV DX,223H         ; Channels 7-12 register port 223h
            MOV AL,1CH          ;   Sound/Frequency enable register
            OUT DX,AL           ; Select sound enable register

            DEC DX              ; Point to data port 222h
            MOV AL,1            ; Register address 1
            OUT DX,AL           ; enable all sound for voice#7-12

;Following codes output music note middle C to voice#1 :

            MOV DX,221H         ; address register for voices 1-6

               ; Program the amplitude

            MOV AL,0
            OUT DX,AL           ; select internal amplitude registers
            DEC DX              ; point to data port 220h
            MOV AL,3AH          ; left amplitude 10, right amplitude 3

               ; Program the frequency

            INC DX              ; point to address port 221h
            MOV AL,8            ; frequency of tone 1/7
            OUT DX,AL           ; select internal frequency registers
            DEC DX              ; point to data port 220h
            MOV AL,83           ; frequency value for middle C
            OUT DX,AL           ; send it to port

               ; Program the octave

            INC DX              ; point to register port 221h
            MOV AL,10H          ;   octave 2/8; octave 1/7
            OUT DX,AL           ; select internal octave registers
            DEC DX              ; point to data port 220h
            MOV AL,03H          ; octave value 3 (middle C) for voice #1
            OUT DX,AL           ; Send it to 220h

               ;frequency enable

            INC DX              ; point to address port 221h
            MOV AL,14H          ;   frequency enable
            OUT DX,AL           ; select internal octave registers
            DEC DX              ; point to data port 220h
            MOV AL,01H          ; enable voice# 1 frequency
            OUT DX,AL           ; send to 220h.

              ;quit

            MOV AX,4CH
            INT 21h

            END
