#include <stdio.h>
#include <string.h>
#include <process.h>
#include <nwbindry.h>
#include <nwconn.h>
#include <nwcntask.h>
#include <nwserial.h>
#include <signal.h>

void main(int, char *[]) ;
void CleanUp();
void printSerialNo();
void scanServers();


char serverPattern[48];


void main(int argc, char *argv[])
{
// Setup an exit cleanup procedure
    signal (SIGINT,  CleanUp);
    signal (SIGTERM, CleanUp);
    signal (SIGABRT, CleanUp);

    if (argc > 1)
       strcpy(serverPattern, strupr(argv[1]));  // use parameter to scan other servers
       else
       strcpy(serverPattern, "");


    printf("SERIALNO.NLM  -  Usage: 'LOAD SERIALNO [search pattern]'\n\n");
    printf("My ");
    printSerialNo();
    printf("\n\n");

    scanServers();
}


void CleanUp()
{
    Logout();
}


void printSerialNo()
{
  long serialno;
  int  cCode;
  int  appno;

  cCode = GetNetworkSerialNumber(&serialno, &appno);

  if (cCode)
    printf("Cannot read serial number (err 0x%X) ", cCode);
    else
    printf("Serial Number: %08lX-%04X ", serialno, appno);
}



void scanServers()
{
long objectID;
char serverName[48];
WORD objectType;
WORD fileServerID;
char objHasProp;
char objSec;
char objFlag;
int  cCode;
int  cCode2;
char srv_user[128];
char activity;

objectID = -1;
activity = 0;

do
     {
     cCode = ScanBinderyObject(serverPattern, OT_FILE_SERVER, &objectID, serverName,
		&objectType, &objHasProp, &objFlag, &objSec);

     activity++;
     if (activity & 1)
	printf("+\b");
	else
	printf("-\b");

     if (cCode == 0)
	{
	strcpy(srv_user, serverName);
	strcat(srv_user, "\\GUEST");
	cCode2 = LoginToFileServer(srv_user, OT_USER, "");
	if (cCode2)
	   {
	   strcpy(srv_user, serverName);
	   strcat(srv_user, "\\SERIALNO");   // try as user SERIALNO
	   cCode2 = LoginToFileServer(srv_user, OT_USER, "");
	   }
	if (cCode2 == 0)
	   {
	   cCode2 = GetFileServerID(serverName, &fileServerID);
	   if (cCode2 == 0)
	      {
	      cCode2 = SetCurrentFileServerID(fileServerID);
	      printSerialNo();
	      printf("%s\n", serverName);
	      cCode2 = SetCurrentFileServerID(0);
	      LogoutFromFileServer(fileServerID);
	      }
	   }
	}
     }
     while (cCode == 0);
     printf(" \b");
}
