// pci.h
//	Header file for definitions of class pci_vga and pci_bios

#ifndef __pci_h
	#define __pci_h
#define CONFIG_ADDRESS	0x0CF8
#define CONFIG_DATA		0x0CFC
#define PCI_INT		0x1A
#define TRUE			1
#define FALSE			0


typedef unsigned long ulong;
typedef unsigned char uchar;
typedef unsigned short uint;


// "dword" is a special class which facilitates the manipulation of
// a 32-bit register.  The class offers access to a single 32-bit value
// via 8-bit access, 16-bit access, or 32-bit access
//
// Class supports copy constructor, opreator "=" assignment to types
// of ULONG or DWORD
#ifndef __dword_struct
	#define __dword_struct
union dword
{
public:
	ulong dw;
	struct	{
          uint w0;
          uint w1;
     } w;

     struct	{
     	uchar b0;
          uchar b1;
          uchar b2;
          uchar b3;
     } b;

     // Constructors
     dword( void )
   	 	{	dw = 0;	};
	dword( ulong init_value )
     	{	dw = init_value;	};
     dword( long init_value )
     	{	dw = (ulong)init_value;	};
     dword( dword &init_dword )
     	{	dw = init_dword.dw;	};

     dword&
	operator =( ulong value )
	{
		dw = value;
		return *this;
	};
};
#endif

// PCI BIOS characteristics returned by BIOS call 0x1A, check_installation
struct bios_info_type
{
	uchar major_version;
     uchar minor_version;
     uchar last_bus;
     uchar hardware_characteristics;
};


struct pci_device_handle_type
{
	uint device;	// Device_ID (16-bit)
     uint vendor;	// Vendor_ID (16-bit)
     uint index;	// Index (0-n)

     uchar bus;		// Bus# of PCI-device

     union {
     	uchar byte;
          struct {
               unsigned char func:3;
			unsigned char dev:5;
          } x;
     }	f;
	//	f.byte represents func/device byte
	//	where bits 7-3=device, 2-0=function
     //	f.x.func represents function (3-bit value)
     //	f.x.dev represents device (5-bit value)
};


class pci_bios_type
{
protected:
	uchar installed;	// Indicates whether PCI_BIOS is installed
	bios_info_type *bios_info;
     	// BIOS information, as returned by PCI BIOS call 0xB101

public:
	bios_info_type * installation_check( void );
     	// Returns pointer to bios_info if PCI_BIOS detected
          // NULL otherwise

     uchar find_device( pci_device_handle_type *pci_device );
     	// Attempts to locate device specified in *pci_device
          // Returns TRUE if successful, FALSE otherwise

     uchar read_cbyte( const pci_device_handle_type pci_device,
		const uint index, uchar *value );
     	// Returns BIOS code
          // If successful, read_cbyte() places read-config-byte into *value

     uchar write_cbyte( const pci_device_handle_type pci_device,
		const uint index, const uchar value );
     	// Returns BIOS code

     pci_bios_type();
     	// Constructor initially calls BIOS for presence of PCI,
          // sets "installed" to TRUE or FALSE accordingly.  And loads
          // bios_info with pci_information returned by the BIOS call

     ~pci_bios_type();	// Destructor

};

#endif