/* --------------------------------- mouse.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Handler for the mouse as a pointing device for UNIX/X11.
*/

#include <stdio.h>
#include <stdlib.h>

#include "fly.h"

extern int GetMouse (POINTER *p);

static int FAR
cal (POINTER *p)
{
	return (0);
}

static int FAR
init (POINTER *p)
{
	return (0);
}

static void FAR
term (POINTER *p)
{
	p->flags = 0;
}

static int FAR
read (POINTER *p)
{
  return (GetMouse (p));    /* see grX.c */
}

struct PtrDriver PtrMouse = {
	"MOUSE",
	0,
	init,
	term,
	cal,
	cal,			/* center */
	read,
	std_key
};
