/* --------------------------------- speed.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* paint the Head Up Display: speed
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "fly.h"
#include "hud.h"

#undef CP
#undef CW
#undef CS

#define CP	view->viewport
#define CW	view->window
#define CS	view->screen

extern void FAR
show_speed (VIEW *view, OBJECT *p, int sx, int sy, int maxx, int maxy,
	int orgx, int orgy, int ttx, int tty, int tx, int ty, int ss)
{
	int	hud, hud1, big, fine, xfine, fa18, f16, f15, fc, knots;
	int	x, y, base, s, x0, y0, dd, dm, i, ex, v;
	int	scale_ref, scale_len;
	long	t;
	char	*w;

	hud = EE(p)->hud;
	hud1 = EE(p)->hud1;
	fine = hud & HUD_FINE;
	xfine = hud & HUD_XFINE;
	big = hud & HUD_BIG;
	i = hud1 & HUD_TYPES;
	fa18 = i == HUD_FA18;
	f16  = i == HUD_F16;
	f15  = i == HUD_F15;
	fc  = i == HUD_CLASSIC;
	knots = hud1 & HUD_KNOTS;

	if (sx < 100) {
		if (xfine)
			fine = 1;
		xfine = 0;
	}

	dd = num_size (9L, ss);

	if (knots) {
		v = p->speed/2;
		v = (v + fmul (v, 15465))/(VONE/2);	/* knots */
	} else
		v = p->speed/VONE;			/* meter/sec */

	if (fa18) {
		s = (ss*7+3)/6;				/* the large font */
		dm = num_size (9L, s);
		dm = 4*dm + 1;
		x = sx;
		y = fmul (sx, F18SPD) + dm;
		if (x > y)
			x = y;
		x = orgx - x;
		if (!(EE(p)->hud2 & HUD_SPEED))
			goto no_speed18;

		add_line (x,     orgy,     T_MOVE);	/* outline */
		add_line (x,     orgy+s+1, st.hfg);
		add_line (x+dm,  orgy+s+1, st.hfg);
		add_line (x+dm,  orgy,     st.hfg);
		add_line (x,     orgy,     st.hfg);
		t = v;
		dm -= num_size (t, s);
		stroke_num (x+dm, orgy+s, t, s, st.hfg);
no_speed18:
		dm = dd*3/2;
		y0 = fmul(sy, F18LINE);
		if (y0 < s)
			y0 = s;
		y = orgy+fmul(sy, F18LINE0);
{
		ANGLE	beta;

		beta = p->speed ? ASIN (fdiv (EE(p)->v[X], p->speed)) : 0;
		stroke_char (x,    y-y0, 'B', ss, st.hfg);
		stroke_frac (x+dm, y-y0, ANG2DEG00(beta)/10, 0, 1, ss, st.hfg);
}
		stroke_char (x, y, 'A', ss, st.hfg);
		stroke_frac (x+dm, y, ANG2DEG00(EE(p)->misc[7])/10, 0, 1, ss,
				st.hfg);

		y += y0;
		if (!(EE(p)->equip & EQ_GEAR)) {
			stroke_char (x, y, 'M', ss, st.hfg);
			t = EE(p)->misc[10]/10;
			stroke_frac (x+dm, y, t, 0, 2, ss, st.hfg);
		}

		y += y0;
		stroke_char (x, y, 'G', ss, st.hfg);
		t = (muldiv (EE(p)->misc[5], 100, GACC) + (s>0 ? 5 : -5)) / 10;
		stroke_frac (x+dm, y, t, 0, 1, ss, st.hfg);

		y += y0;
		stroke_frac (x+dm, y, 90L, 0, 1, ss, st.hfg);	/* max G */

		if ((i = EE(p)->weapon)) {
		    	y = orgy + fmul (sy, F18WEAPON);
		    	w = get_wname (p);
		    	dm = stroke_size (w, s);

		    	y += y0;		/* weapon */
		    	stroke_str (orgx-dm/2, y, w, s, st.hfg);

		    	y += y0;		/* rounds left */
		    	stroke_num (orgx-dm/2, y,
				(long)EE(p)->stores[i-1], s, st.hfg);
		}
	} else {
	    scale_ref = f16 ? 16 : (f15 ? 15 : 30);
	    scale_len = f16 ?  8 : (f15 ?  8 : EE(p)->tapelen);

	    if (v >= 0) {
		x0 = (int)(v % 100L);
		ex = (int)(v/100);
	    } else {
		x0 = 100-(int)((-v) % 100L);
		ex = -(int)(-v/100 + 1);
	    }
	    s = x0/10;
	    y0 = x0 - s*10;
	    y0 = orgy + muldiv (y0, sy, scale_ref*10);
	    base = orgx;
	    if (f15)
	    	base -= fmul (sx, F15SPD);
	    else if (f16)
	    	base -= fmul (sx, F16SPD);
	    else
	    	base -= sx;
	    dm = 2+tx;
	    if (!(EE(p)->hud2 & HUD_SPEED))
		goto no_speed16;
	    if (f15) {
		y = muldiv (scale_len, sy, scale_ref);
		add_line (base, orgy - y, T_MOVE);
		add_line (base, orgy + y, st.hfg);
	    }
	    for (i = 1-scale_len, s += i; i <= scale_len; ++i, ++s) {
		y = y0 - muldiv (i, sy, scale_ref);
		if (f16||f15) {
			if (f15)
				y = 2*orgy - y;
			if (0 == s%5) {
				t = ex*10 + s;
				if (f15)
					t *= 10;
				if (!big)
					dm = -num_size (t, ss)-tx;
				stroke_num (base+dm, y+ss/2, t, ss, st.hfg);
			}
			add_line (base,       y, T_MOVE);
			add_line (base-1*ttx, y, st.hfg);
		} else if (0 == s%10) {
			add_line (base, y, T_MOVE);
			add_line (base -3*ttx, y, st.hfg);
			if (xfine || (i >= -11 && i <= 11)) {
				t = ex + s/10;
				if (!big)
					dm = -num_size (t, ss)-tx;
				stroke_num (base+dm, y-2, t,
					ss, st.hfg);
			}
		} else if (fine) {
			if (0 == s%2) {
				add_line (base, y, T_MOVE);
				add_line (base-1*ttx, y, st.hfg);
			}
		} else if (0 == s%5) {
			add_line (base, y, T_MOVE);
			add_line (base-2*ttx, y, st.hfg);
		} else if (xfine) {
			add_line (base, y, T_MOVE);
			add_line (base-1*ttx, y, st.hfg);
		}
	    }
	    if (big)
		base += 3*tx;
	    if (f15) {
		    add_line (base+2*tx, orgy-ty, T_MOVE); /* reading mark */
		    add_line (base,      orgy,    st.hfg);
		    add_line (base+2*tx, orgy+ty, st.hfg);
	    } else {
		    add_line (base,      orgy, T_MOVE);	/* reading mark */
		    add_line (base+3*tx, orgy, st.hfg);
	    }
no_speed16:
	    if (f16||f15||fc) {
	    	if (fc)
	    		base += 3*dd;
	    	y = orgy + muldiv (sy, scale_len, scale_ref) + ss;

	    	y += ss;
	    	stroke_str (base-3*dd, y, get_wname (p), ss, st.hfg);

	    	y += ss;
		t = EE(p)->misc[10];		/* mach no. */
	    	stroke_frac (base-2*dd, y, t, -1, 3, ss, st.hfg);

	    	y += ss;
		s = EE(p)->misc[5] * 10;
		if (s > 0)
			s += GACC/2;
		else
			s -= GACC/2;
		t = s / GACC;
		x = base-3*dd;
	    	x += stroke_frac (x, y, t, 0, 1, ss, st.hfg);
		stroke_char (x+dd, y, 'G', ss, st.hfg);
	    }
	}
}
