/* --------------------------------- misc.c --------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Miscelanious functions for Microsoft WINDOWS 3.X.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>

#include <windows.h>

#include "config.h"
#include "fly.h"

extern int FAR			/* debug utility */
looping (int i)
{
	static int	n;

	if (!i)
		n = 0;
	else if (++n > i)
		return (1);

	return (0);
}

extern int FAR
stricmp (const char *a, const char *b)
{
  int t;

  for (; *a && *b; ++a, ++b) {
    t = toupper(*a) - toupper (*b);
    if (t > 0)
      return (1);
    else if (t < 0)
      return (-1);
  }
  return (0);
}

extern int FAR
strnicmp (const char *a, const char *b, int n)
{
  int t;

  for (; n-- > 0 && *a && *b; ++a, ++b) {
    t = toupper(*a) - toupper (*b);
    if (t > 0)
      return (1);
    else if (t < 0)
      return (-1);
  }
  return (0);
}

char *
strdup (string)
register char *string;
{
	register char *p;

	if (p = malloc (strlen(string) + 1))
		strcpy (p, string);
	return (p);
}
