/* --------------------------------- keyboard.c ----------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Keyboard drivers manager.
*/

#include <stdio.h>
#include <string.h>

#include "fly.h"

extern struct KbdDriver *KbdDrivers[];

extern struct KbdDriver *FAR
keyboard_init (char *name)
{
	struct KbdDriver	**p;

	p = KbdDrivers;
	if (name)
		for (; *p; ++p)
			if (!stricmp ((*p)->name, name))
				break;
	return (*p);
}

extern void FAR
keyboard_term (void)
{
	return;
}
