/* --------------------------------- colors.c ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* color handling.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "fly.h"
#include "colors.h"

#define COLOR_NAME_LENGTH	6

static long FAR
ShowColor (Ulong color)
{
	return ((0x00ff0000LU & (color << 16)) |
		(0x0000ff00LU & (color)) |
		(0x000000ffLU & (color >> 16)));
}

#if 0
static long FAR
grey_color (long color)			/* get intensity */
{
	int	r, g, b, w;

	r = 0x0ff & (int)(color);
	g = 0x0ff & (int)(color >> 8);
	b = 0x0ff & (int)(color >> 16);

	w = (r*67+g*21+b*15)/(67+21+15);

	return (w | (w<<8) |((long)w<<16));
}
#endif

extern long FAR
hi_color (long color)			/* highlight a color */
{
	Uint	r, g, b, m;

	r = 0x0ff & (Uint)(color);
	g = 0x0ff & (Uint)(color >> 8);
	b = 0x0ff & (Uint)(color >> 16);

	m = (r > g) ? r : g;
	if (b > m)
		m = b;
	if (!m)
		return (color);
	
	r = (Uint)muldiv (r, 0x0ff, m);
	g = (Uint)muldiv (g, 0x0ff, m);
	b = (Uint)muldiv (b, 0x0ff, m);

	return (r | (g<<8) | ((long)b<<16));
}

static MENU MenuCoOp[] = {
	{'+', "Brighter"},	/*  0 */
	{'-', "Darker"},	/*  1 */
	{'=', "New"},		/*  2 */
	{'*', "Restore"},	/*  3 */
{'\0', 0}};

#define	COLOR_STEP	8

static void FAR
get_color (char *name, int index, long *color)
{
	Uint	r, g, b;
	int	sel;
	long	l, newc;
	char	msg[9];
	HMSG	*m;

	newc = *color;

	m = MsgWPrintf (0, name);

	sel = 3;
	do {
		if (m)
			sprintf (m->text+COLOR_NAME_LENGTH+1, "%06lx",
				ShowColor (newc));
		Gr->SetPalette (index, newc);

		r = 0x0ff & (Uint)(newc);
		g = 0x0ff & (Uint)(newc >> 8);
		b = 0x0ff & (Uint)(newc >> 16);

		sel = menu_open (MenuCoOp, sel);

		switch (sel) {
		default:
		case MENU_ABORTED:
		case MENU_FAILED:
			break;
		case 0:
			if ((r += (r+COLOR_STEP-1)/COLOR_STEP) > 0x0ff)
				r = 0x0ff;
			if ((g += (g+COLOR_STEP-1)/COLOR_STEP) > 0x0ff)
				g = 0x0ff;
			if ((b += (b+COLOR_STEP-1)/COLOR_STEP) > 0x0ff)
				b = 0x0ff;
			newc = r | (g<<8) | ((long)b<<16);
			break;
		case 1:
			r -= (r+COLOR_STEP-1)/COLOR_STEP;
			g -= (g+COLOR_STEP-1)/COLOR_STEP;
			b -= (b+COLOR_STEP-1)/COLOR_STEP;
			newc = r | (g<<8) | ((long)b<<16);
			break;
		case 2:
			getstr ("color RRGGBB", msg, sizeof (msg));
			if (1 == sscanf (msg, "%lx", &l)) {
				b = (Uchar)(0x0ff & (l      ));
				g = (Uchar)(0x0ff & (l >> 8 ));
				r = (Uchar)(0x0ff & (l >> 16));
				if (r > 0x0ff || g > 0x0ff || b > 0x0ff)
					MsgEPrintf (50, "*** Bad primary");
				else
					newc = r | (g<<8) | ((long)b<<16);
			} else
				MsgEPrintf (50, "*** Bad color");
			break;
		case 3:
			newc = *color;
			break;
		}
		if (MENU_FAILED != sel)
			menu_close ();
	} while (sel >= 0);
	*color = newc;

	msg_del (m);
	m = 0;
}

#if 0
static struct {
	char	*name;
	int	*index;
	long	color;
} colors[] = {
	{"Black",   &st.black,   C_BLACK},
	{"White",   &st.white,   C_WHITE},
	{"Red",     &st.red,     C_RED},
	{"Blue",    &st.blue,    C_BLUE},
	{"Magenta", &st.magenta, C_MAGENTA},
	{"Green",   &st.green,   C_GREEN},
	{"Brown",   &st.brown,   C_BROWN},
	{"Gray",    &st.gray,    C_GRAY},
	{"HudLow",  &st.hudlow,  C_LYELLOW},
	{"HudHigh", &st.hudhigh, C_YELLOW},
	{"Pilot",   &st.lred,    C_LIGHTRED},
	{"Sky",     &st.lblue,   C_SKYBLUE},
	{"Border",  &st.lgray,   C_LIGHTGRAY},
	{"Ground",  &st.ground,  C_GRAY},
{0,0,0}};
#endif

static Ulong HudHigh =		0xffffffffL /*C_LYELLOW*/;	/* kludge */
static Ulong HudLow =		0xffffffffL /*C_YELLOW*/;	/* kludge */
static Ulong SkyBlue =		C_SKYBLUE;
static Ulong PilotRed =		C_LIGHTRED;
static Ulong GroundGray =	C_GRAY;

extern int FAR
menu_colors (void)
{
	MENU	*MenuColors;
	int	sel, i, n, nEntries, EntrySize;

	if (0xffffffffL == HudLow) {			/* kludge */
		HudLow = st.hud_color;
		HudHigh = hi_color (HudLow);
	}

	nEntries = 4;
	EntrySize = 20;

	n = (nEntries+1) * sizeof (*MenuColors);
	if (!(MenuColors = (MENU *) memory_alloc (n)))
		return (1);

	sel = MENU_FAILED;
	for (i = 0; i < nEntries; ++i)
		if (!(MenuColors[i].text = (char *) memory_alloc (EntrySize)))
			goto ret;

#define SETCOLOR(i,l,n,v) \
	MenuColors[i].letter = l;			\
	sprintf (MenuColors[i].text, "%-*s %06lx",	\
		COLOR_NAME_LENGTH, n, ShowColor (v));

	SETCOLOR (0, 'h', "HUD",    HudLow);
	SETCOLOR (1, 's', "Sky",    SkyBlue);
	SETCOLOR (2, 'p', "Pilot",  PilotRed);
	SETCOLOR (3, 'g', "Ground", GroundGray);

#undef SETCOLOR

	sel = menu_open (MenuColors, 0);

	switch (sel) {
	default:
	case MENU_ABORTED:
	case MENU_FAILED:
		break;
	case 0:
		get_color (MenuColors[sel].text, st.hfg, &HudLow);
		HudHigh = hi_color (HudLow);
		Gr->SetPalette (st.hfgi, HudHigh);
		break;
	case 1:
		get_color (MenuColors[sel].text, st.lblue, &SkyBlue);
		break;
	case 2:
		get_color (MenuColors[sel].text, st.lred, &PilotRed);
		break;
	case 3:
		get_color (MenuColors[sel].text, st.ground, &GroundGray);
		break;
	}

ret:
	for (i = 0; i < nEntries; ++i)
		if (MenuColors[i].text)
			memory_free (MenuColors[i].text, EntrySize);

	memory_free (MenuColors, n);

	if (MENU_FAILED == sel)
		return (1);

	menu_close ();
	return (0);
}
