#include "vgl.h"

static char far Pal[768];

vglBlack()
{
   memset( Pal, 0, 768 );
   vglSetPal( Pal );
}

vglFadeIn( char far* palette )
{
   int i, j, v;

   for( i = 0; i < 32; i++ )
   {
      for( j = 0; j < 768; j++ )
         Pal[j] =  (i * (unsigned)palette[j]) >> 5;
      vglSetPal( Pal );
   }
}

vglFadeOut( char far* palette )
{
   int i, j, v;

   for( i = 31; i >= 0; i-- )
   {
      for( j = 0; j < 768; j++ )
         Pal[j] =  (i * (unsigned)palette[j]) >> 5;
      vglSetPal( Pal );
   }
}

vglPartFadeIn( int first, int num, char far* palette )
{
   int i, j, v;

   for( i = 0; i < 32; i++ )
   {
      for( j = 0; j < num * 3; j++ )
         Pal[j] =  (i * (unsigned)palette[j]) >> 5;
      vglSetPartPal( first, num, Pal );
   }
}

vglPartFadeOut( int first, int num, char far* palette )
{
   int i, j, v;

   for( i = 31; i >= 0; i-- )
   {
      for( j = 0; j < num * 3; j++ )
         Pal[j] =  (i * (unsigned)palette[j]) >> 5;
      vglSetPartPal( first, num, Pal );
   }
}

vglPartCycleL( int first, int num, char far* palette )
{
   int i, a, b, c;

   num--;
   a = palette[0];
   b = palette[1];
   c = palette[2];
   for( i = 0; i < num * 3; i++ )
      palette[i] = palette[i + 3];
   palette[i] = a;
   palette[i + 1] = b;
   palette[i + 2] = c;
   vglSetPartPal( first, num + 1, palette );
}

vglPartCycleR( int first, int num, char far* palette )
{
   int i, a, b, c;

   i = (num * 3) - 1;
   a = palette[i - 2];
   b = palette[i - 1];
   c = palette[i];
   for( ; i >= 3; i-- )
      palette[i] = palette[i - 3];
   palette[0] = a;
   palette[1] = b;
   palette[2] = c;
   vglSetPartPal( first, num, palette );
}
