/*-----------------------------------------------------------------------
;
; XPOINT - header file
;
;
;
; ****** XLIB - Mode X graphics library                ****************
; ******                                               ****************
; ****** Written By Themie Gouthas                     ****************
;
; Macros written by Mathew Mackenzie
;
; egg@dstos3.dsto.gov.au
; teg@bart.dsto.gov.au
;
;  Terminology & notes:
;         VRAM ==   Video RAM
;         SRAM ==   System RAM
;         X coordinates are in pixels unless explicitly stated
;
;-----------------------------------------------------------------------*/

#ifndef _XBMTOOLS_H_
#define _XBMTOOLS_H_

#define BM_WIDTH_ERROR 1

#define LBMHeight(lbitmap) lbitmap[1]
#define LBMWidth(lbitmap) lbitmap[0]
#define PBMHeight(pbitmap) pbitmap[1]
#define PBMWidth(pbitmap) (4*pbitmap[0])

#define LBMPutPix(x,y,lbitmap,color)  \
	(lbitmap[2 + (x) + (y) * (LBMHeight(lbitmap))] = color)

#define LBMGetPix(x,y,lbitmap)  \
	(lbitmap[2 + (x) + (y) * (LBMHeight(lbitmap))])



/* FUNCTIONS =========================================================== */

extern int x_pbm_to_bm(           /* Convert from planar bitmap to linear */
	 char far * source_pbm,
	 char far * dest_bm);

extern int x_bm_to_pbm(           /* Convert from linear bitmap to planar */
	 char far * source_pbm,
	 char far * dest_bm);

#endif


