/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//	WINDOW.H					(c)	YoY'00						WEB: www.aestesis.org
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef							_WINDOW_H_
#define							_WINDOW_H_
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include						<windows.h>
#include						"surface.h"
#include						"section.h"
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//	If you use directly the variables in the class API, it's at your own risks. Prefer the methods...   

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define							guidWINDOW						(Awindow::CI.guid)

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Awindow : public Asurface
{
public:
	ADLL static ACI				CI;
	virtual ACI					*getCI							()						{ return &CI; }

	HWND						hwFather;
	HWND						hw;

	ADLL						Awindow							(char *name, int x, int y, int w, int h, bool useBlend=false);
	ADLL						Awindow							(char *name, HWND hwFather, int x, int y, int w, int h, bool useBlend=false);

	ADLL virtual				~Awindow						();

								// notifications ///////////////

	ADLL virtual void			repaint							(bool now=FALSE);
	ADLL virtual void			repaint							(Arectangle r, bool now=FALSE);

	virtual bool				notify							(Anode *o, int event, dword p=0)			{ return FALSE; }

								// commands ////////////////////

	ADLL virtual bool			show							(bool visible);
	ADLL virtual bool			zorder							(int action);
	ADLL virtual bool			move							(int x, int y);
	ADLL virtual bool			size							(int w, int h);
	ADLL virtual bool			mouseCapture					(bool b, Aobject *o=NULL);
	ADLL virtual bool			focus							(Aobject *o=NULL);

								// global //////////////////////

	// private /////////////////////

	ADLL virtual void			del								(Anode *o);

	ADLL virtual dword			NCnotify						(dword m, dword wp, dword lp);
	static int					NCmessageLoop					();
	static void					NCasyncNotify					(class asyncMessage *am);
	static void					NCclearAll						();

	int							mouseX,mouseY;
	int							mouseTime,mouseState;

	Aobject						*objectTrack;

	class Asection				updateSection;
	bool						inUpdate;

	Aobject						*keyboardFocusOBJ;

	HDC							hdc;		// 4 transparency
	HBITMAP						hbm;		// 4 transparency
	bool						useBlend;	// 4 transparency

protected:
	Aobject						*mouseCaptureOBJ;

	ADLL virtual bool			NCmouse							(int x, int y, int state, int event);
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// private functions (internals)
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool							NCglobalTimer					(Aobject *o, int time);
void							NCdestroy						(Aobject *o);

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class asyncMessage
{
public:
	class Anode					*to;
	class Anode					*o;
	int							event;
	dword						p;

								asyncMessage(class Anode *to, class Anode *o, int event, dword p)
								{
									this->to=to;
									this->o=o;
									this->event=event;
									this->p=p;
								}
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif							//_WINDOW_H_
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
