    ' This file is provided as part of ASP Power Widgets Samples
    '
    ' THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT
    ' WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
    ' INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
    ' OF MERCHANTABILITY AND/OR FITNESS FOR A  PARTICULAR
    ' PURPOSE.

    ' Copyright 1998-2002. All rights reserved.
    ' Dalun Software Inc. ASP Power Widgets
    ' http://dalun.com 
    ' mail: sales@dalun.com
    ' mail: techsupport@dalun.com
    ' if you have any suggestions or requirements, please write to us.
    ' Revisions:
    ' 2.0.0   Initial release

    'Dump all POP3 mails and save them to local storage.

    Option explicit
    
    Dim strTicket
    Dim strXMLMailList
    Dim objPOP3
    Dim objFS
    Dim objMailListXMLDOM
    
    Dim strServer
    Dim strUserId
    Dim strPassword
    Dim oNodes
    Dim item
    
    Set objPOP3 = CreateObject("ASPPW.POP3.1")
    Set objFS = CreateObject("Scripting.FileSystemObject") 

    If WScript.Arguments.Count <> 3 Then
        WScript.Echo "Usage: cscript DumpAll.vbs <POP3 Server> <UserId> <Password>"
        WScript.Quit(0)
    End If

    strServer = WScript.Arguments(0)
    strUserId = WScript.Arguments(1)
    strPassword = WScript.Arguments(2)
    
    strTicket =  objPOP3.logon(strServer, "110", strUserId, strPassword)
    Set objMailListXMLDOM = objPOP3.getmaillist(strTicket, 100000, 0) 

    Set oNodes = objMailListXMLDOM.selectNodes("//MailList/*")

    WScript.Echo "You have " & oNodes.Length & " mail(s)."

    For Each item in oNodes
        Dim id, file, strRaw
        Set id = item.selectSingleNode("@Id")
        WScript.Echo "Processing mail " & id.text 
        Set file = objFS.OpenTextFile(("Mail_" & NormId(id.text) & ".eml"), 2, true)
        strRaw = objPOP3.getrawmaildata(strTicket, id.text)
        file.write(strRaw)
        file.close()               
        strTicket = objPOP3.refreshticket(strTicket)
    Next
    WScript.Echo oNodes.Length & " mail(s) processed."

    Function NormId(strId)
        If Len(strId) = 1 Then
            NormId = "000" & strId
        End If
        If Len(strId) = 2 Then
            NormId = "00" & strId
        End If
        If Len(strId) = 3 Then
            NormId = "0" & strId
        End If
        If Len(strId) > 3 Then
            NormId = strId
        End If    
    End function


