/* repport.c - This file is a part of Floke Integrity
 *      Copyright (C) 2000 Jon Wickmann
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Written by Jon Wickmann <jon.wickmann@excite.com>, 2000.
 * For contact information please see http://www.angelfire.com/wi/wickmann/contact.html
 * Floke Integrity http://www.angelfire.com/wi/wickmann/floke.html
 * Please observe modification guidelines in the documentation
 *
 * History:
 * File last modified 2000.09.14. JWi
 *  */
#include "flokecore.h"
#include <time.h>

typedef struct report //Structure to hold repport data
{
	FILE *out; //Where to print //Currently not working
	unsigned int files; //Files scanned
	unsigned int newfiles; //New files
	unsigned int deletedfiles; //Deleted files
	unsigned int changedfiles; //Changed files
	unsigned int cleardfiles; //Files that are OKAY
} my_report;

//unsigned int fileStatusfile(FILE *out, struct fileentry *infileentry, unsigned char status, struct direntry *indirentry, BOOL dirnameprinted);
//unsigned int fileStatus(FILE *out, struct direntry *indirentry, unsigned char status);

void make_repport()
{
	//verbose=100;
	FILE *out;
	//unsigned int files; //Files scanned //Now gone global
	unsigned int newfiles; //New files
	unsigned int deletedfiles; //Deleted files
	unsigned int changedfiles; //Changed files
	unsigned int cleardfiles; //Files that are OKAY
	unsigned int accesdeniedfiles;



		out=fopen(report->reportfile,"a");

		if(report->makeheader==TRUE)
			{
				fprintf(out,"\nFloke report\n");
				fprintf(out,"============\n");
			}
		if(report->makeheader_time==TRUE)
			{
				time_t now;
				time(&now);
				fprintf(out,"Created at: %.24s.\n", ctime(&now));
			}
		if(report->reportNewFiles==TRUE)
			{
				fprintf(out,"These files are new:\n");
			}
		newfiles=fileStatus(out,memstartdir,INITIAL,report->reportNewFiles,report->reportNewFilesWithHashes);
		if(report->reportNewFiles==TRUE)
			{
				if(newfiles==0)
					{
						fprintf(out,"NONE\n");
					}
			}
		if(report->reportNewFiles==TRUE)
			{
				fprintf(out,"============\n");
			}
		if(report->reportChangedFiles==TRUE)
			{
				fprintf(out,"These files have changed:\n");
			}
		changedfiles=fileStatus(out,memstartdir,CHANGED,report->reportChangedFiles, report->reportChangedFilesWithHashes);
		//changedfiles=fileStatus(out,memstartdir,CHANGED,TRUE, TRUE); //Force
		if(report->reportChangedFiles==TRUE)
			{
				if(changedfiles==0)
					{
						fprintf(out,"NONE\n");
					}
				fprintf(out,"============\n");
			}
		if(report->reportCleardFiles==TRUE)
			{
				fprintf(out,"These files are cleard:\n");
			}
		cleardfiles=fileStatus(out,memstartdir,OKAY,report->reportCleardFiles, report->reportCleardFilesWithHashes);
		if(report->reportCleardFiles==TRUE)
			{
				if(cleardfiles==0)
					{
						fprintf(out,"NONE\n");
					}

				////fprintf(out,"============\n");
				fprintf(out,"============\n");
			}
		if(report->reportDeletedFiles==TRUE)
			{
				fprintf(out,"These files have been removed:\n");
			}
		//deletedfiles=fileStatus(NULL,memfilestartdir,INITIAL); //NOT Proved that we can void output
		//deletedfiles=fileStatus(out,memfilestartdir,INITIAL,report->reportDeletedFiles, report->reportDeletedFilesWithHashes);
		deletedfiles=fileStatus(out,memfilestartdir,INITIAL,report->reportDeletedFiles, report->reportDeletedFilesWithHashes);
		if(report->reportDeletedFiles==TRUE)
			{
				if(deletedfiles==0)
					{
						fprintf(out,"NONE\n");
					}

				fprintf(out,"============\n");
			}
		if(report->reportAccesDeniedFiles==TRUE)
			{
				fprintf(out,"These files have access problems:\n");
			}
		//deletedfiles=fileStatus(NULL,memfilestartdir,INITIAL); //NOT Proved that we can void output
		//accesdeniedfiles=fileStatus(out,memfilestartdir,ACCES_DENIED,report->reportAccesDeniedFiles, FALSE);
		accesdeniedfiles=fileStatus(out,memfilestartdir,ACCES_DENIED,TRUE, FALSE);
		if(report->reportAccesDeniedFiles==TRUE)
			{
				if(accesdeniedfiles==0)
					{
						fprintf(out,"NONE\n");
					}

				fprintf(out,"============\n");
			}


		if(report->makesummary==TRUE)
			{
				fprintf(out,"\n");
				fprintf(out,"Summary:\n");
				fprintf(out,"\n");
				fprintf(out,"Scanned files: %u\n",files);
				fprintf(out,"New files: %u\n",newfiles);
				fprintf(out,"Not checked files %u\n",accesdeniedfiles);
				fprintf(out,"Changed files: %u\n",changedfiles);
				fprintf(out,"Deleted files: %u\n",deletedfiles);
				fprintf(out,"Cleard files: %u\n",cleardfiles);
			}
		fclose(out);
		//verbose=0;
		ui_summary(files, newfiles, deletedfiles, changedfiles, cleardfiles, accesdeniedfiles);
}
unsigned int fileStatus(FILE *out, struct direntry *indirentry, unsigned char instatus, BOOL printit, BOOL printhashes)
{
	unsigned int fstemp=0;
	if(indirentry!=NULL)
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELFOUR)
				{
					fprintf(errverboseout,"fileStatus Dir Name %s \n", indirentry->dirname);
				}
			#endif
			if(indirentry->firstfile!=NULL)
				{
					//if(indirentry->firstfile->filename[0]!=NIL)
					//	{
							fstemp=fstemp+fileStatusfile(out,indirentry->firstfile, instatus,indirentry,FALSE, printit, printhashes);
					//	}
				}




			if(indirentry->firstsub!=NULL)
				{
					fstemp=fstemp+fileStatus(out,indirentry->firstsub,instatus,printit, printhashes);
				}
			if(indirentry->next!=NULL)
				{
					fstemp=fstemp+fileStatus(out,indirentry->next,instatus,printit, printhashes);
				}
		}
	return fstemp;
}

unsigned int fileStatusfile(FILE *out, struct fileentry *infileentry, unsigned char instatus, struct direntry *indirentry, BOOL dirnameprinted, BOOL printit, BOOL printhashes)
{

	unsigned int fsstemp=0;

	if(infileentry->filename[0]!=NIL)
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELFOUR)
				{
					fprintf(errverboseout,"fileStatusfile File Name %s status %08c, instatus %08c\n", infileentry->filename,infileentry->status,instatus);
					/*
					if(infileentry->status==OKAY)
								{
									fprintf(errverboseout,"fileStatusfile infileentry->status==OKAY instatus %08c\n",instatus);
								}
					if(infileentry->status==CHANGED)
								{
									fprintf(errverboseout,"fileStatusfile infileentry->status==CHANGED instatus %08c\n",instatus);
								}
					if(infileentry->status==INITIAL)
								{
									fprintf(errverboseout,"fileStatusfile infileentry->status==INITIAL instatus %08c\n",instatus);
								}*/
				}
			//fprintf(errverboseout,"fileStatusfile infileentry->status %08c instatus %08c\n",infileentry->status,instatus);
			#endif
			if(infileentry->status==instatus)
				{
					if(dirnameprinted==FALSE)
						{
							if(printit==TRUE)
								{
									fprintf(out,"%s\n", indirentry->dirname);
								}
						}
					fsstemp++;
					if(printit==TRUE)
								{
									if(infileentry->filename[0]!=0)
										{
											fprintf(out,"%s\n", infileentry->filename);
											if(printhashes==TRUE)
												{
													if(hash!=TIGER)
														{
															if(hash==SHA1)
																{
																	fprintf(out,"%08x %08x %08x %08x %08x\n",infileentry->hash[0],infileentry->hash[1],infileentry->hash[2],infileentry->hash[3],infileentry->hash[4]);
																}
															if(hash!=SHA1)
																{
																	print_hex(infileentry->hash,(hashinfo->hashlenght)*sizeof(unsigned long),out);
																	fprintf(out,"\n");
																}
														}
													if(hash==TIGER)
														{
															print_hex(infileentry->hashbig,hashinfo->hashlenght,out);
															fprintf(out,"\n");
														}
												}
										}

								}
					//if(infileentry->next!=NULL)
					//	{
					//		fsstemp=fsstemp+fileStatusfile(out,infileentry->next, instatus,indirentry,TRUE,printit, printhashes);
					//	}
				}
		}
	if(infileentry->next!=NULL)
			{
					fsstemp=fsstemp+fileStatusfile(out,infileentry->next, instatus,indirentry,TRUE,printit, printhashes);

			}
	return fsstemp;
}

void print_hex( byte *p, size_t n,FILE *out )
{
    int i;
	/*
    if( n == 20 ) {
        for(i=0; i < n ; i++, i++, p += 2 ) {
            if( i )
                putchar(' ');
            if( i == 10 )
                putchar(' ');
            printf("%02X%02X", *p, p[1] );
        }
    }
    else if( n == 24 ) {
        for(i=0; i < n ; i += 4, p += 4 ) {
            if( i )
                putchar(' ');
            if( i == 12 )
                putchar(' ');
            printf("%02X%02X%02X%02X", *p, p[1], p[2], p[3] );
        }
    }
    else { */
        for(i=0; i < n ; i++, p++ ) {
            //if( i )
                //putchar(' ');
            if( i && !(i%4) ) //8
                fputc(' ',out);
            fprintf(out,"%02x", *p );
        //}
    }
}

