/* files.c - This file is a part of Floke Integrity
 *      Copyright (C) 2000 Jon Wickmann
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Written by Jon Wickmann <jon.wickmann@excite.com>, 2000.
 * For contact information please see http://www.angelfire.com/wi/wickmann/contact.html
 * Floke Integrity http://www.angelfire.com/wi/wickmann/floke.html
 * Please observe modification guidelines in the documentation
 *
 * History:
 * File last modified 2000.09.14. JWi
 *  */
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include <stdio.h>
#include "flokecore.h"

unsigned char dirwarner; //Warn if dir detected

unsigned char boolToUnsingnedChar(BOOL in);

struct fileentry *loadfiles(FILE *f,struct fileentry *inPrev);
struct direntry *loaddirentry(FILE *f,struct direntry *direntry);

unsigned char boolToUnsingnedChar(BOOL in)
{
	if(in==TRUE)
		{
			return 1;
		}
	if(in==FALSE)
		{
			return 0;
		}
}
void comitAllEntriesToFile(unsigned char infilename[MAX_PATH])
{
	FILE *f;
	f=fopen(infilename,"wb");
	fwrite(databasefileid, sizeof(unsigned char), strlen(databasefileid),f); //Write identifier tag
	fwrite(&databasefileversion, sizeof(unsigned char), 1,f); //Write file version

	//Write header
	fwrite(&hash, sizeof(unsigned char), 1,f);
	fwrite(&hashinfo->hashlenght, sizeof(size_t), 1,f);

	fprintf(f,"%s\n",report->reportfile);
	fprintf(f,"%s\n",searchpattern);
	fprintf(f,"%s\n",startpath);

	unsigned char booltmp;

	booltmp=boolToUnsingnedChar(report->makeheader);
	fwrite(&booltmp, sizeof(unsigned char), 1,f);

	booltmp=boolToUnsingnedChar(report->makeheader_time);
	fwrite(&booltmp, sizeof(unsigned char), 1,f);

	booltmp=boolToUnsingnedChar(report->reportScannedFiles);
	fwrite(&booltmp, sizeof(unsigned char), 1,f);

	booltmp=boolToUnsingnedChar(report->reportScannedFilesWithHashes);
	fwrite(&booltmp, sizeof(unsigned char), 1,f);

	booltmp=boolToUnsingnedChar(report->reportCleardFiles);
	fwrite(&booltmp, sizeof(unsigned char), 1,f);

	booltmp=boolToUnsingnedChar(report->reportCleardFilesWithHashes);
	fwrite(&booltmp, sizeof(unsigned char), 1,f);

	booltmp=boolToUnsingnedChar(report->reportChangedFiles);
	fwrite(&booltmp, sizeof(unsigned char), 1,f);

	booltmp=boolToUnsingnedChar(report->reportChangedFilesWithHashes);
	fwrite(&booltmp, sizeof(unsigned char), 1,f);

	booltmp=boolToUnsingnedChar(report->reportChangedFilesWithHashes);
	fwrite(&booltmp, sizeof(unsigned char), 1,f);

	booltmp=boolToUnsingnedChar(report->reportDeletedFiles);
	fwrite(&booltmp, sizeof(unsigned char), 1,f);

	booltmp=boolToUnsingnedChar(report->reportDeletedFilesWithHashes);
	fwrite(&booltmp, sizeof(unsigned char), 1,f);

	booltmp=boolToUnsingnedChar(report->reportNewFiles);
	fwrite(&booltmp, sizeof(unsigned char), 1,f);

	booltmp=boolToUnsingnedChar(report->reportAccesDeniedFiles);
	fwrite(&booltmp, sizeof(unsigned char), 1,f);

	booltmp=boolToUnsingnedChar(report->makesummary);
	fwrite(&booltmp, sizeof(unsigned char), 1,f);

	filedumpeveryentry(f,memstartdir);
	fwrite(dirmarker, sizeof(unsigned char), 2,f); // Write end of file
	fwrite(endoffilemarker, sizeof(unsigned char), 1,f); // Write end of file
	fclose(f);


}

BOOL unsignedCharToBool(unsigned char in)
{
	if(in==1)
		{
			return TRUE;
		}

	if(in==0)
		{
			return FALSE;
		}
}
BOOL readFromFileToMem(unsigned char infilename[MAX_PATH])
{
	dirwarner=0;
	CR[0]=0xA; // Sett Carrier return
	unsigned char CRLF[]={0xA,0xC};
	unsigned char tmpchrs[2];
	unsigned char tmpchr[1];
	unsigned char tmpchrI[1];
	unsigned char tmpid[7];
	FILE *f;
	f=fopen(infilename,"rb");

	//Read header
	fread(tmpid,sizeof(unsigned char),6,f);
	tmpid[6]=0;
	databasefileid2[6]=0;
	if(strcmp(tmpid,databasefileid2)==0)
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELONE)
				{
					fprintf(errverboseout,"readFromFileToMem : File not id'ed as ours\n");
				}
			#endif
			//return FALSE; //For now
		}
	fread(tmpchr,sizeof(unsigned char),1,f);
	databasefileversion=tmpchr[0];
	fread(tmpchr,sizeof(unsigned char),1,f);
	hash=tmpchr[0];

	size_t tmphashlenght[1];
	fread(tmphashlenght, sizeof(size_t), 1,f);
	hashinfo->hashlenght=tmphashlenght[0];

	unsigned int g=0;

	fread(tmpchrI,sizeof(unsigned char),1,f); //To use or not to use?
	while(tmpchrI[0]!=CR[0])
		{
			report->reportfile[g]=tmpchrI[0];
			fread(tmpchrI,sizeof(unsigned char),1,f);
			g++;
		}
	report->reportfile[g]=NIL;
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELONE)
				{
					fprintf(errverboseout,"readFromFileToMem : report->reportfile %s\n",report->reportfile);
				}
			#endif
	g=0;
	fread(tmpchrI,sizeof(unsigned char),1,f); //To use or not to use?
	while(tmpchrI[0]!=CR[0])
		{
			searchpattern[g]=tmpchrI[0];
			fread(tmpchrI,sizeof(unsigned char),1,f);
			g++;

		}
	searchpattern[g]=NIL;
	g=0;
	fread(tmpchrI,sizeof(unsigned char),1,f); //To use or not to use?
	while(tmpchrI[0]!=CR[0])
		{
			startpath[g]=tmpchrI[0];
			fread(tmpchrI,sizeof(unsigned char),1,f);
			g++;
		}
	startpath[g]=NIL;



	//Report data
	fread(tmpchr,sizeof(unsigned char),1,f);
	report->makeheader=unsignedCharToBool(tmpchr[0]);

	fread(tmpchr,sizeof(unsigned char),1,f);
	report->makeheader_time=unsignedCharToBool(tmpchr[0]);

	fread(tmpchr,sizeof(unsigned char),1,f);
	report->reportScannedFiles=unsignedCharToBool(tmpchr[0]);

	fread(tmpchr,sizeof(unsigned char),1,f);
	report->reportScannedFilesWithHashes=unsignedCharToBool(tmpchr[0]);

	fread(tmpchr,sizeof(unsigned char),1,f);
	report->reportCleardFiles=unsignedCharToBool(tmpchr[0]);

	fread(tmpchr,sizeof(unsigned char),1,f);
	report->reportCleardFilesWithHashes=unsignedCharToBool(tmpchr[0]);

	fread(tmpchr,sizeof(unsigned char),1,f);
	report->reportChangedFiles=unsignedCharToBool(tmpchr[0]);

	fread(tmpchr,sizeof(unsigned char),1,f);
	report->reportChangedFilesWithHashes=unsignedCharToBool(tmpchr[0]);

	fread(tmpchr,sizeof(unsigned char),1,f);
	report->reportDeletedFiles=unsignedCharToBool(tmpchr[0]);

	fread(tmpchr,sizeof(unsigned char),1,f);
	report->reportDeletedFilesWithHashes=unsignedCharToBool(tmpchr[0]);

	fread(tmpchr,sizeof(unsigned char),1,f);
	report->reportNewFiles=unsignedCharToBool(tmpchr[0]);

	fread(tmpchr,sizeof(unsigned char),1,f);
	report->reportNewFilesWithHashes=unsignedCharToBool(tmpchr[0]);

	fread(tmpchr,sizeof(unsigned char),1,f);
	report->reportAccesDeniedFiles=unsignedCharToBool(tmpchr[0]);

	fread(tmpchr,sizeof(unsigned char),1,f);
	report->makesummary=unsignedCharToBool(tmpchr[0]);


	//memfilestartdir=memAllocdir(NULL);

	if (memfilestartdir==NULL)
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELONE)
				{
					fprintf(errverboseout,"readFromFileToMem : Memory allocation error\n");
				}
			#endif
		}

	fread(tmpchrs,sizeof(unsigned char),2,f);
	if(tmpchrs[0]==dirmarker[0])
		{
			if(tmpchrs[1]==dirmarker[1])
				{
					#ifdef DEBUGHELPERS
					if (verbose>ERRVERBOSELEVELFOUR)
						{
							fprintf(errverboseout,"loadfiles : dirmarker[] encountred in redFromFileToMem \n");
						}
					#endif

					memfilecurdir=memAllocdir(NULL);// Inserted to handel err in c:\PROGRAM assigment
					memfilestartdir=loaddirentry(f,memfilecurdir);// Inserted to handel err in c:\PROGRAM assigment
					//memfilestartdir=loaddirentry(f,memAllocdir(NULL));
				}
		}

	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELFOUR)
			{
				fprintf(errverboseout,"loadfiles : ends \n");
			}
	#endif



	fclose(f);


}

struct direntry *loaddirentry(FILE *f,struct direntry *direntry)
{
	unsigned char tmpchr[1];

	unsigned int i=0;
	unsigned int watchrangespath=0;


	watchrangespath=0;
	i=0;

/*	if(direntry==NULL)
		{
			direntry=memAllocdir(NULL); //added 20000913
		}*/

	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELFIVE)
				{
					fprintf(errverboseout,"loaddirentry : reading new entry\n");
				}
	#endif
	tmpchr[0]=0; //1832

	while(tmpchr[0]!=CR[0])
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELFIVE)
				{
					fprintf(errverboseout,"loaddirentry : while(tmpchr[0]!=CR[0])\n");
				}
			#endif
			fread(tmpchr,sizeof(unsigned char),1,f);
			if(tmpchr[0]==endoffilemarker[0])
								{
									#ifdef DEBUGHELPERS
									if (verbose>ERRVERBOSELEVELFIVE)
											{
												fprintf(errverboseout,"loaddirentry : tmpchr[0]==endoffilemarker[0]\n");
											}
									#endif
									if(dirwarner==2)
										{
											dirwarner=3;
											#ifdef DEBUGHELPERS
											if (verbose>ERRVERBOSELEVELFOUR)
												{
													fprintf(errverboseout,"loadfiles : issued dirwarner 3 -- End of File \n");
												}
											#endif
											tmpchr[0]=*"\n";
										}
								}
			if(dirwarner==3)
				{
					#ifdef DEBUGHELPERS
					if (verbose>ERRVERBOSELEVELFIVE)
							{
								fprintf(errverboseout,"loaddirentry : dirwarner==3 -> return NULL\n");
							}
					#endif
					return NULL;
				}
			/*if(eof(f)==1)
				{
					//tmpchr[0]=CR[0];
					return NULL;

				}*/
			direntry->dirname[i]=tmpchr[0];
			i++;
			watchrangespath++;
			if(watchrangespath>(MAX_PATH-3))
				{
					#ifdef DEBUGHELPERS
					if (verbose>ERRVERBOSELEVELFOUR)
						{
							fprintf(errverboseout,"loaddirentry : watchrangespath to high %i\n",watchrangespath);
						}
					#endif
					//tmpchr[0]="\n";
				}
		}
	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELFIVE)
				{
					fprintf(errverboseout,"loaddirentry : reading new entry end\n");
				}
	#endif
	i--;
	direntry->dirname[i]=NIL;
	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELFOUR)
				{
					fprintf(errverboseout,"loaddirentry : Dir Name %s \n", direntry->dirname);
				}
	#endif
	if(memfilecurdir==NULL)
				{
					#ifdef DEBUGHELPERS
					if (verbose>ERRVERBOSELEVELONE)
						{
							fprintf(errverboseout,"loaddirentry : memfilecurdir==NULL\n");
						}
					#endif
						//memfilecurdir=memAllocdir(direntry); //Temporatu to solve problem
					memfilecurdir=memAllocdir(NULL); //Temporatu to solve problem
					//tmpchr[0]="\n";
				}

	memfilecurdir->firstfile=loadfiles(f,NULL);
	if(memfilecurdir->firstfile==NULL)
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELONE)
						{
							fprintf(errverboseout,"loaddirentry : memfilecurdir->firstfile==NULL\n");
						}
			#endif
		}
	if(memfilecurdir->firstfile!=NULL)
		{

			memfilecurfile=memfilecurdir->firstfile;
			while(memfilecurfile!=NULL)
				{
					memfilepriorfile=memfilecurfile;
					memfilecurfile=loadfiles(f,memfilepriorfile);
					memfilepriorfile->next=memfilecurfile;
					//memfilecurdir->firstfile->next=memfilecurfile;
					//fprintf(errverboseout,"loaddirentry : memfilecurdir->firstfile->next=memfilecurfile\n");
				}

		}

	//Problem
	// Allocate memory?
	// Parsing??
	// Seems to work now
	//if(memfilecurdir!=NULL)
	//	{
			memfilepriordir=memfilecurdir;
	//	}
	memfilecurdir=memAllocdir(memfilepriordir);
	//if(direntry!=NULL)
	//	{
			direntry->next=loaddirentry(f,memfilecurdir);
	//	}
	return direntry;

}

struct fileentry *loadfiles(FILE *f,struct fileentry *inPrev)
{
	char tmpchr[1];
	unsigned int watchrangespath=0;
	unsigned int i=0;
	memfilecurfile=memAllocfile(inPrev);

	dirwarner=0;
	fread(tmpchr,sizeof(unsigned char),1,f);

	if(tmpchr[0]==dirmarker[0])
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELFOUR)
				{
					fprintf(errverboseout,"loadfiles : issued dirwarner 1 \n");
				}
			#endif
			dirwarner=1;
		}
	while(tmpchr[0]!=CR[0])
		{
			memfilecurfile->filename[i]=tmpchr[0];
			i++;
			fread(tmpchr,sizeof(unsigned char),1,f);
			watchrangespath++;
				if(watchrangespath>(MAX_PATH-3))
					{
						#ifdef DEBUGHELPERS
						if (verbose>ERRVERBOSELEVELFOUR)
							{
								fprintf(errverboseout,"loadfiles : watchrangespath to high %i\n",watchrangespath);
							}
						#endif
						//tmpchr[0]="\n";
					}


			if(eof(f)==1)
				{
					tmpchr[0]=CR[0];
					return NULL;
				}
			if(dirwarner==1)
						{
							if(tmpchr[0]!=dirmarker[1])
								{
									#ifdef DEBUGHELPERS
									if (verbose>ERRVERBOSELEVELFOUR)
										{
											fprintf(errverboseout,"loadfiles : issued dirwarner 0 \n");
										}
									#endif
									dirwarner=0;
								}
						}
			if(tmpchr[0]==dirmarker[0])
				{
					#ifdef DEBUGHELPERS
					if (verbose>ERRVERBOSELEVELFOUR)
						{
							fprintf(errverboseout,"loadfiles : issued dirwarner 1 \n");
						}
					#endif
					dirwarner=1;
				}
			if(tmpchr[0]==dirmarker[1])
				{
					if(dirwarner==1)
						{
							dirwarner=2;
							#ifdef DEBUGHELPERS
							if (verbose>ERRVERBOSELEVELFOUR)
								{
									fprintf(errverboseout,"loadfiles : issued dirwarner 2 \n");
								}
							#endif
							tmpchr[0]=CR[0];
						}
				}
							if(tmpchr[0]==endoffilemarker[0])
								{
									if(dirwarner==2)
										{
											dirwarner=3;
											#ifdef DEBUGHELPERS
											if (verbose>ERRVERBOSELEVELFOUR)
												{
													fprintf(errverboseout,"loadfiles : issued dirwarner 3 -- End of File \n");
												}
											#endif
											tmpchr[0]=*"\n";
										}
								}


		}
	memfilecurfile->filename[i]=NIL;
	if (dirwarner==2)
		{
			//free(memfilecurfile);
			i--;
			memfilecurfile->filename[i]=NIL;
			//i--;
			//memfilecurfile->filename[i]=NIL;
			return NULL;
		}
	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELFOUR)
				{
					fprintf(errverboseout,"loadfiles : File Name %s \n", memfilecurfile->filename);
				}
	#endif
	if(hash==SHA1)
		{
			fread(memfilecurfile->hash, sizeof(unsigned long), 5,f);
		}
	if(hash==MD5)
		{
			fread(memfilecurfile->hash, sizeof(unsigned long), 4,f);
		}
	if(hash==RMD160)
		{
			fread(memfilecurfile->hash, sizeof(unsigned long), 5,f);
		}
	if(hash==TIGER)
		{
			fread(memfilecurfile->hashbig, sizeof(unsigned long long), 3,f);
		}
	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELFOUR)
				{
					fprintf(errverboseout,"loadfiles : Hash %08x %08x %08x %08x %08x\n",memfilecurfile->hash[0],memfilecurfile->hash[1],memfilecurfile->hash[2],memfilecurfile->hash[3],memfilecurfile->hash[4]);
				}
	#endif
	if (dirwarner<2)
		{
			//memfilecurfile->next=memAllocfile(memfilecurfile);

			//loadfiles(f,memfilecurfile->next);
		}
	return memfilecurfile;
}

