/* 
   Copyright 2001-2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include "lsctrl.h"

#define TITLEWIDTH 15
#define EDGEWIDTH 1
#define TITLETOP 3
#define BARLEFT 2
#define BARRIGHT 2
#define BARTOP 2

static char *szToolBarWindClassName = "ladSoftToolBarWindow" ;

static LRESULT  CALLBACK _export ControlWindWndProc( HWND hwnd, UINT iMessage, WPARAM wParam,
                                                         LPARAM lParam )
{
   RECT r, *pr,r1  ;
   PAINTSTRUCT ps ;
   HDC dc ;
   CCW_params *ptr ;
   static int skip ;
   static int dragging,oncursor,sizing ;
   static HCURSOR oldCursor ;
   POINT temppt ;
   int temp ;
   int i;
   HBRUSH brush ;
	LPTOOLTIPTEXT lpt ;
   LPMINMAXINFO minmax ;
   SIZE size ;
   switch(iMessage) {
      case WM_NOTIFY:
         ptr = (CCW_params *)GetWindowLong(hwnd,0) ;
			switch(((LPNMHDR)lParam)->code) {
				case TTN_NEEDTEXT :
					lpt = (LPTOOLTIPTEXT)lParam ;	
               for (i=0; i < ptr->u.tb.btncount ; i++)
                  if (ptr->u.tb.buttons[i].idCommand == lpt->hdr.idFrom) {                     lpt->lpszText = ptr->u.tb.hints[i] ;
							break ;
						}
               break ;
            default:
               return SendMessage(ptr->u.tb.notifyparent,iMessage,wParam,lParam) ;
			}
         break ;
      case WM_PAINT:
         dc = BeginPaint(hwnd, &ps) ;
         GetClientRect(hwnd,&r) ;
         EndPaint(hwnd, &ps) ;
         break ;
      case WM_COMMAND:
         ptr = (CCW_params *)GetWindowLong(hwnd,0) ;
         return SendMessage(ptr->u.tb.notifyparent,iMessage,wParam,lParam) ;
         break ;
		case WM_CREATE :
         ptr = HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,sizeof(CCW_params)) ;
         SetWindowLong(hwnd,0,(DWORD)ptr) ;
         *ptr = *(CCW_params *)(((LPCREATESTRUCT)lParam)->lpCreateParams) ;
         ptr->self = hwnd ;
         ptr->type = LSTOOLBAR ;
//         return 0 ;
         ptr->u.tb.btncount = 0 ;
         while (ptr->u.tb.buttons[ptr->u.tb.btncount].fsStyle || ptr->u.tb.buttons[ptr->u.tb.btncount].idCommand)
            ptr->u.tb.btncount++ ;
         ptr->u.tb.hWnd = CreateToolbarEx(hwnd,WS_CHILD | (ptr->u.tb.hints ? TBSTYLE_TOOLTIPS : 0) | TBSTYLE_WRAPABLE, 
                        ptr->u.tb.bmpid,ptr->u.tb.bmpcount,(HINSTANCE)GetWindowLong(hwnd,GWL_HINSTANCE),
                        ptr->u.tb.bmpid, ptr->u.tb.buttons, ptr->u.tb.btncount, 
                        ptr->u.tb.width,ptr->u.tb.height,ptr->u.tb.width,ptr->u.tb.height,
                        sizeof(TBBUTTON)) ;
         SendMessage(ptr->u.tb.hWnd,TB_GETITEMRECT,ptr->u.tb.btncount-1,(LPARAM)&r) ;
         ptr->u.tb.hsize.cx = r.right + GetSystemMetrics(SM_CXFRAME) ;
         ptr->u.tb.hsize.cy = r.bottom + GetSystemMetrics(SM_CYFRAME) ;
         MoveWindow(hwnd,0,0,ptr->u.tb.hsize.cy,ptr->u.tb.hsize.cx,0) ;
         ptr->u.tb.vWnd = CreateToolbarEx(hwnd,WS_CHILD | (ptr->u.tb.hints ? TBSTYLE_TOOLTIPS : 0) | TBSTYLE_WRAPABLE, 
                        ptr->u.tb.bmpid,ptr->u.tb.bmpcount,(HINSTANCE)GetWindowLong(hwnd,GWL_HINSTANCE),
                        ptr->u.tb.bmpid, ptr->u.tb.buttons, ptr->u.tb.btncount, 
                        ptr->u.tb.width,ptr->u.tb.height,ptr->u.tb.width,ptr->u.tb.height,
                        sizeof(TBBUTTON)) ;
         SendMessage(ptr->u.tb.vWnd,TB_GETITEMRECT,ptr->u.tb.btncount-1,(LPARAM)&r) ;
         ptr->u.tb.vsize.cx = r.right + GetSystemMetrics(SM_CXFRAME) ;
         ptr->u.tb.vsize.cy = r.bottom + GetSystemMetrics(SM_CYFRAME) ;
         SendMessage(hwnd,LCF_SETVERTICAL,0,ptr->vertical) ;
         dmgrAddClient(ptr) ;
			return 0 ;
		case WM_DESTROY:
         ptr = (CCW_params *)GetWindowLong(hwnd,0) ;
         dmgrRemoveClient(ptr) ;
         HeapFree(GetProcessHeap(),0,ptr) ;
         break ;
      case LCF_SETVERTICAL:
         ptr = (CCW_params *)GetWindowLong(hwnd,0) ;
         ptr->vertical = (int)lParam ;
         if (ptr->vertical) {
            ShowWindow(ptr->u.tb.hWnd,SW_HIDE) ;
            ShowWindow(ptr->u.tb.vWnd,SW_SHOW) ;
            MoveWindow(hwnd,0,(int)wParam,ptr->u.tb.vsize.cx,ptr->u.tb.vsize.cy,1) ;
         } else {
            ShowWindow(ptr->u.tb.vWnd,SW_HIDE) ;
            ShowWindow(ptr->u.tb.hWnd,SW_SHOW) ;
            MoveWindow(hwnd,(int)wParam,0,ptr->u.tb.hsize.cx,ptr->u.tb.hsize.cy,1) ;
         }
         return 0 ;
		case WM_CLOSE:
         ptr = (CCW_params *)GetWindowLong(hwnd,0) ;
         dmgrHideWindow(ptr->id,TRUE) ;
         return 0 ;
      case WM_SIZE :
         return 0 ;
      default :
         if (iMessage >= WM_USER && iMessage <= WM_USER + 100) {
            ptr = (CCW_params *)GetWindowLong(hwnd,0) ;
            return SendMessage(ptr->u.tb.hWnd, iMessage, wParam, lParam) ;
         }
	}
   return DefWindowProc(hwnd, iMessage, wParam, lParam) ;
}

void RegisterToolBarWindow(HINSTANCE hInstance)
{
		WNDCLASS wc ;
      wc.style = 0 ;
      wc.lpfnWndProc = &ControlWindWndProc ;
		wc.cbClsExtra = 0;
      wc.cbWndExtra = sizeof(LPVOID);
		wc.hInstance = hInstance ;
		wc.hIcon = LoadIcon(0,IDI_APPLICATION) ;
		wc.hCursor = LoadCursor(0,IDC_ARROW) ;
      wc.hbrBackground = CreateSolidBrush(GetSysColor(COLOR_INACTIVEBORDER)) ; 
		wc.lpszMenuName = 0 ;
      wc.lpszClassName = szToolBarWindClassName ;
		RegisterClass(&wc) ;

}
HWND CreateToolBarWindow(int id, HWND notify, HWND parent, int width, int height, int bmp, int bmpcount, 
      TBBUTTON *buttons, char **hints, int vertical, char *title)
{
   CCW_params p ;
   HWND hwnd ;
   RECT r1,r2 ;
   memset(&p,0,sizeof(p)) ;
   p.vertical = vertical ;
   p.u.tb.width = width ;
   p.u.tb.height = height ;
   p.u.tb.buttons = buttons ;
   p.u.tb.hints = hints ;
   p.u.tb.bmpid = bmp ;
   p.u.tb.bmpcount = bmpcount ;
   p.u.tb.notifyparent = notify ;
   p.title = title ;
   p.id = id ;
   hwnd = CreateWindow(szToolBarWindClassName, "",
            WS_CLIPSIBLINGS | WS_VISIBLE | WS_CHILD,
            CW_USEDEFAULT, CW_USEDEFAULT, 1000, 30,
            parent, (HMENU)0 ,(HINSTANCE)GetWindowLong(parent,GWL_HINSTANCE), &p) ;

   return hwnd ;
}