/******************************************************************************/
/* FILE           : splash.h  -  Splash screen include file                   */
/* DESCRIPTION    : Structures/definitions for splash screen functions        */
/* LANGUAGE       : "C"                                                       */
/* PLATFORM       : Windows 95/98/98SE/ME/NT4/2000                            */
/* AUTHOR         : Andrea Binello  <andrea.binello@tiscalinet.it>            */
/* LICENSE        : Freeware - Open Source                                    */
/* LAST UPDATE    : May 06, 2001                                              */
/******************************************************************************/

#ifndef __SPLASH_H__
#define __SPLASH_H__

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
   HWND        hWndOwner;
   HINSTANCE   hInstance;
   HINSTANCE   hInstanceRes;
   LPSTR       lpszResource;
   USHORT      uTime;
   BOOL        bCentered;
   BOOL        bTopmost;
   BOOL        bWait;
   INT         iPosX;
   INT         iPosY;
} SPLASH, FAR* LPSPLASH;

VOID WINAPI SplashScreen (LPSPLASH lpSplash);

#ifdef __cplusplus
}
#endif

#endif