/* 
   Copyright 2001-2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include "operands.h"
#include <stdio.h>
#include "utype.h"

BOOL useim;

void SegmentDisplay( char *buffer, long value )
{
	sprintf(buffer,"sg_%x", value);
}
void FormatValue(char *buffer, OPERAND *record, uint segs, uint type)
{
    segs++;
    switch(type) {
	case SY_SIGNEDOFS:
		if (record->address < 0)
			sprintf(buffer,"-os_%x", (BYTE) ABS(record->address));
		else
			sprintf(buffer,"+os_%x", (BYTE) record->address);
		break;
	case SY_WORDOFS:
		sprintf(buffer,"+ow_%lx", record->address);
		break;
	case SY_BYTEOFS:
		sprintf(buffer,"+ob_%x",  (BYTE) record->address);
		break;
	case SY_ABSOLUTE:
		sprintf(buffer,"ad_%lx", record->address);
		break;
	case SY_SIGNEDIMM:
		if (record->address < 0)
		  sprintf(buffer,"-is_%x", ABS(record->address));
		else
		  sprintf(buffer,"+is_%x", record->address);
		break;
	case SY_WORDIMM:
		if (useim)
			sprintf(buffer,"iw_%lx", record->address);
		else
			sprintf(buffer,"offset ad_%lx", record->address);
		break;
	case SY_BYTEIMM:
		sprintf(buffer,"ib_%x", (BYTE)(record->address));
		break;
	case SY_PORT:
		sprintf(buffer,"p_%x",(BYTE) record->address);
		break;
	case SY_INTR:
		sprintf(buffer,"it_%x",(BYTE) record->address);
		break;
	case SY_RETURN:
		sprintf(buffer,"rt_%x", (uint) record->address);
		break;
	case SY_ABSBRANCH:
		sprintf(buffer,"ba_%lx", record->address);
		break;
	case SY_LONGBRANCH:
		sprintf(buffer,"bl_%lx", record->address);
		break;
	case SY_SHORTBRANCH:
		sprintf(buffer,"bs_%lx", record->address);
		break;
	case SY_SHIFT:
		    sprintf(buffer,"ib_%x", (BYTE) record->address);
		    break;
	case SY_SEGMENT:
		SegmentDisplay( buffer, record->segment);
		break;
    }
}
void AddSymbol(OPERAND *record, uint type)
{
  record++;
  type++;
}
