///////////////////////////////////////////////////
// Draw It
//   Yet another simple WinZilla example
//
//  (C) Copyright 1998 WinZilla Software
//  Sure it's copyrighted, but you can use it.
///////////////////////////////////////////////////


#include <windows.h>

#include "winzilla.h"

// first, enumerate the drawing commands
enum
{
    LINE_MODE = WM_USER,
    CIRCLE_MODE,
    RECT_MODE,
    SEP_MODE,
    CHOOSE_PEN,
    CHOOSE_FILL,
    THICKER,
    THINNER,
    QUIT_PROG

} e_options;


// The standard WinMain definition
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   PSTR szCmdLine, int iCmdShow)
{
    HWND        my_window;          // our drawing window
    HWND        icon_bar;
    int         x1, y1;             // coordinates we'll use for drawing
    int         x2, y2;
    int         result;             // to know when the user cancels
    int         pen_width = 0;      // a default pen width to work with

    WZ_MENUMAP(icon_bar_menu)
    WZ_MAP("lines.bmp",     LINE_MODE)
    WZ_MAP("circles.bmp",   CIRCLE_MODE)
    WZ_MAP("boxes.bmp",     RECT_MODE)
    WZ_MAP("pencolor.bmp",  CHOOSE_PEN)
    WZ_MAP("filcolor.bmp",  CHOOSE_FILL)
    WZ_MAP("thicker.bmp",   THICKER)
    WZ_MAP("thinner.bmp",   THINNER)
    WZ_MAP("quit.bmp",      QUIT_PROG)
    WZ_ENDMAP

    
    // initialize WinZilla
    WZ_Init(hInstance, NULL);

    // open the window (the TRUE at the end means use a back buffer for drawing)
    my_window = WZ_OpenWindow(WZ_DEFAULT, "Simple Drawing Demo", NULL, WZ_NullFunc, TRUE);

    // give the window a scroll bar
    WZ_SetAutoScroll(my_window, TRUE);

    // Put up a simple menu, map messages starting with LINE_MODE
    // Note: this function is mostly for simple apps, you *should* use WZ_SetMenubarFromResource
    WZ_Menubar(my_window, LINE_MODE, TRUE, 
        "&Drawing Commands,&Lines,&Circles,&Rectangles,~,&Pen Color,&Fill Color,&Thicken Pen,T&hinner Pen,&Quit");

    // Add Icon Bar, 1 column of icons, mapped to our commands
    icon_bar = WZ_AddIconBar(icon_bar_menu, 1, my_window);


    // Assign default pens to the application window
    WZ_SetPenColor(my_window, RGB(0,0,255));
    WZ_SetFillColor(my_window, RGB(0,255,0));

    do
    {
        // wait on the user to select a menu item
        WZ_GetMenu();

        // which did he pick? (WZ_LastCommand is maintained by WinZilla internally)
        switch(WZ_LastCommand)
        {
            case LINE_MODE:
                WZ_SetButtonState(icon_bar, LINE_MODE, TRUE);
                // let the user draw a line
                do
                {
                    result = WZ_GetPoint(&x1, &y1, TRUE);
                    if ( result == WZ_SUCCESS )
                    {
                        result = WZ_GetPoint2(x1, y1, &x2, &y2, TRUE);
                        if ( result == WZ_SUCCESS )
                        {
                            WZ_MoveTo(my_window, x1, y1);
                            WZ_LineTo(my_window, x2, y2);
                        }
                    }
                } while(result == WZ_SUCCESS);

                WZ_SetButtonState(icon_bar, LINE_MODE, FALSE);

                break;

            case CIRCLE_MODE:
                WZ_SetButtonState(icon_bar, CIRCLE_MODE, TRUE);
                // let the user draw a circle
                do
                {
                    result = WZ_GetPoint(&x1, &y1, TRUE);
                    if ( result == WZ_SUCCESS )
                    {
                        result = WZ_GetCircle(x1, y1, &x2, &y2, TRUE);
                        if ( result == WZ_SUCCESS )
                        {
                            WZ_Ellipse(my_window, x1, y1, x2, y2);
                        }
                    }
                } while(result == WZ_SUCCESS);

                WZ_SetButtonState(icon_bar, CIRCLE_MODE, FALSE);
                
                break;

            case RECT_MODE:

                WZ_SetButtonState(icon_bar, RECT_MODE, TRUE);

                // let the user draw a rectangle
                do
                {
                    result = WZ_GetPoint(&x1, &y1, TRUE);
                    if ( result == WZ_SUCCESS )
                    {
                        result = WZ_GetCorner(x1, y1, &x2, &y2, TRUE);
                        if ( result == WZ_SUCCESS )
                        {
                            WZ_Rectangle(my_window, x1, y1, x2, y2);
                        }
                    }
                } while (result == WZ_SUCCESS);

                WZ_SetButtonState(icon_bar, RECT_MODE, FALSE);

                break;

            case CHOOSE_FILL:
                WZ_SetButtonState(icon_bar, CHOOSE_FILL, TRUE);
                // let the user choose a fill color for my_window
                {
                    COLORREF color;

                    if (WZ_ChooseColor(&color))
                        WZ_SetFillColor(my_window, color);
                }

                WZ_SetButtonState(icon_bar, CHOOSE_FILL, FALSE);
                
                break;

            case CHOOSE_PEN:
                WZ_SetButtonState(icon_bar, CHOOSE_PEN, TRUE);
                // let the user choose a pen color for my_window
                {
                    COLORREF color;

                    if (WZ_ChooseColor(&color))
                        WZ_SetPenColor(my_window, color);
                }

                WZ_SetButtonState(icon_bar, CHOOSE_PEN, FALSE);
                
                break;

            case THICKER:
                // thicken the pen
                pen_width++;
                WZ_SetPenWidth(my_window, pen_width);
                break;

            case THINNER:
                // thin the pen
                if (pen_width)
                    pen_width--;
                WZ_SetPenWidth(my_window, pen_width);
                break;

        }
    
    // stay locked in our loop until we close the program!
    } while ( !((WZ_LastCommand == QUIT_PROG) || WZ_AppDone) );

    // standard window closure
    return WZ_WMsg.wParam;
}





