program WindowsApp;
{$MODE DELPHI}
uses Windows;

const AppName = 'WindowsApp';
function WindowProc(Window: HWnd; AMessage, WParam,
          LParam: Longint): Longint; stdcall; export;

begin
  WindowProc := 0;

  case AMessage of
    wm_Destroy : begin
                   PostQuitMessage(0);
                   Exit;
                 end;
  end;

  WindowProc := DefWindowProc(Window, AMessage, WParam, LParam);
end;

{ Register the Window Class }
function WinRegister: Boolean;
var WindowClass: WndClass;
begin
  WindowClass.Style := cs_hRedraw or cs_vRedraw;
  WindowClass.lpfnWndProc := WndProc(@WindowProc);
  WindowClass.cbClsExtra := 0;
  WindowClass.cbWndExtra := 0;
  WindowClass.hInstance := system.MainInstance;
  WindowClass.hIcon := LoadIcon(0, idi_Application);
  WindowClass.hCursor := LoadCursor(0, idc_Arrow);
  WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
  WindowClass.lpszMenuName := nil;
  WindowClass.lpszClassName := AppName;
  Result := RegisterClass(WindowClass) <> 0;
end;

{ Create the Window Class }
function WinCreate: HWnd;
var hWindow: HWnd;
begin
  hWindow := CreateWindow(AppName, 'Windows App',
         ws_OverlappedWindow, cw_UseDefault, cw_UseDefault,
         cw_UseDefault, cw_UseDefault, 0, 0, system.MainInstance, nil);

  if hWindow <> 0 then begin
     ShowWindow(hWindow, CmdShow);
     UpdateWindow(hWindow);
  end;

  Result := hWindow;
end;

var AMessage: Msg;
    hWindow: HWnd;

begin
  if not WinRegister then begin
     MessageBox(0, 'Register failed', nil, mb_Ok);
     Exit;
  end;

  hWindow := WinCreate;
  if longint(hWindow) = 0 then begin
     MessageBox(0, 'WinCreate failed', nil, mb_Ok);
     Exit;
  end;

  while GetMessage(@AMessage, 0, 0, 0) do begin
    TranslateMessage(AMessage);
    DispatchMessage(AMessage);
  end;
  Halt(AMessage.wParam);
end.
