// Main.cpp : implementation file
//

#include "stdafx.h"
#include "SerialRedirect.h"
#include "Main.h"

#include "MainFrm.h"

#include "SerialPorts.h"
#include "NetworkPorts.h"
#include "PortServer.h"




#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMain

IMPLEMENT_DYNCREATE(CMain, CFormView)

CMain::CMain()
	: CFormView(CMain::IDD)
{
	//{{AFX_DATA_INIT(CMain)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	nTimerTick = 0;
}

CMain::~CMain()
{
}

void CMain::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMain)
	DDX_Control(pDX, IDC_STATIC_LISTENADDR, m_staticListenAddress);
	DDX_Control(pDX, IDC_PORTLIST, m_listPorts);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMain, CFormView)
	//{{AFX_MSG_MAP(CMain)
	ON_BN_CLICKED(IDC_CMD_ABOUT, OnCmdAbout)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMain diagnostics

#ifdef _DEBUG
void CMain::AssertValid() const
{
	CFormView::AssertValid();
}

void CMain::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMain message handlers






void CMain::OnInitialUpdate() 
{
	CFormView::OnInitialUpdate();

	CMainFrame	*main = (CMainFrame *)AfxGetMainWnd();


	CRect		rectViewOverhead, rectViewClient, rectViewWin;
	CRect		rectFrameWin;

	GetClientRect( rectViewClient );
	GetWindowRect( rectViewWin );

	rectViewOverhead.left = rectViewOverhead.top = 0;
	rectViewOverhead.right = rectViewWin.Width() - rectViewClient.Width();
	rectViewOverhead.bottom = rectViewWin.Height() - rectViewClient.Height();

	main->GetWindowRect( rectFrameWin );



	CDialog dlgTemp;
	CRect	rectDialog;
	dlgTemp.Create( IDD_SERIALREDIRECT_DIALOG );
	dlgTemp.GetWindowRect( rectDialog );


	int	deltaWidth, deltaHeight;

	deltaWidth  = (rectDialog.Width() - rectViewWin.Width()) + rectViewOverhead.Width();
	deltaHeight = (rectDialog.Height() - rectViewWin.Height()) + rectViewOverhead.Height();


	main->m_rectWinMinMax.left	 = main->m_rectWinMinMax.top = 0;
	main->m_rectWinMinMax.right  = rectFrameWin.Width() + deltaWidth;
	main->m_rectWinMinMax.bottom = rectFrameWin.Height() + deltaHeight;
	
	SetupListControl();




	CString	cstrListenAddress, cstrTemp;
	UINT	nport;

	theApp.m_SuperSocket.GetSockName( cstrTemp, nport );

	cstrListenAddress.Format( IDS_FMT_LISTENADDR, (LPCTSTR)theApp.m_cstrNetAddrDesc, (int)nport );

	m_staticListenAddress.SetWindowText(cstrListenAddress);



	CRect	rectTemp;

	main->GetWindowRect( rectTemp );
	main->MoveWindow( rectTemp );
}











#define INSERTCOL(cnum,strnum);	cstr.LoadString(strnum);	\
								lcol.pszText = (LPSTR)(LPCTSTR)cstr;	\
								m_listPorts.InsertColumn(cnum, &lcol);


#define INSERTROW(str);		litem.iItem = m_listPorts.GetItemCount();	\
							litem.iSubItem = 0;	litem.pszText = (LPSTR)(LPCTSTR)str;	\
							rowNum= m_listPorts.InsertItem(&litem);


#define SETCELL(col,str);	litem.iItem = rowNum;	litem.iSubItem = col;	\
							litem.pszText = (LPSTR)(LPCTSTR)str;	\
							m_listPorts.SetItem( &litem );




void CMain::SetupListControl()
{
	LV_COLUMN	lcol;
	LV_ITEM		litem;

	CString		cstr;
	int			rowNum,numColumns= 0;

	lcol.mask = LVCF_FMT | LVCF_TEXT;
	lcol.fmt  = LVCFMT_LEFT;

	INSERTCOL( 0, IDS_LCOL_SERVICE );
	INSERTCOL( 1, IDS_LCOL_SERPORT );
	INSERTCOL( 2, IDS_LCOL_STATUS );
	INSERTCOL( 3, IDS_LCOL_THROUGHPUT );
	INSERTCOL( 4, IDS_LCOL_QDEPTH );

	litem.mask	= LVIF_TEXT;


	POSITION		pspos = theApp.m_listPortServers.GetHeadPosition();
	CPortServer		*cps;

	while( pspos )
	{
		cps = (CPortServer *)theApp.m_listPortServers.GetNext(pspos);

		INSERTROW( cps->svrGetServiceName() );
		SETCELL(1, cps->svrCommGetPortDesc() );
	}

	SetColumnWidths();
}



#undef INSERTCOL
#undef INSERTROW









void CMain::TimerTick(void)
{
	BOOL	isBusy = FALSE;

	if( theApp.nBytesRead + theApp.nBytesWritten ) 
		isBusy = TRUE;

	if( (nTimerTick++ & 1) == 0 )
	{
		LV_ITEM		litem;

		POSITION		pspos = theApp.m_listPortServers.GetHeadPosition();
		CPortServer		*cps;

		CString		cstr;
		int			rowNum = 0;

		litem.mask	= LVIF_TEXT;

		while( pspos )
		{
			cps = (CPortServer *)theApp.m_listPortServers.GetNext(pspos);

			if( (cps->svrGetMasterKey()).IsEmpty() )
				cstr = cps->svrGetStatusText();
			else
				cstr.Format("* %s", (LPCTSTR)cps->svrGetStatusText() );

			SETCELL(2, cstr );

			cstr.Format(IDS_FMT_THROUGHPUT, cps->nBytesRead,cps->nBytesWritten);
			SETCELL(3,cstr);

			cps->nBytesRead = cps->nBytesWritten = 0;
			theApp.nBytesRead = theApp.nBytesWritten = 0;

			cstr.Format(IDS_FMT_QDEPTH, cps->m_listNetReceive.GetCount(), cps->m_listNetTransmit.GetCount() );
			SETCELL(4,cstr);

			rowNum++;
		}

		SetColumnWidths();

		theApp.dblkPruneOldBlocks();
	}

	theApp.AnimateTaskbarIcon(isBusy);
	return;
}









void CMain::SetColumnWidths()
{

	CDC			*cdc = GetDC();
	CString		colText(32,100), itemText(32,100);
	int			colWidth, i= 0,j;
	CSize		tsize;
	LV_COLUMN	lcol;
	LV_ITEM		litem;

	litem.mask = LVIF_TEXT;
	litem.pszText = (LPSTR)(LPCTSTR)itemText;
	litem.cchTextMax = itemText.GetLength();

	lcol.mask = LVCF_TEXT | LVCF_WIDTH;
	lcol.pszText = (LPSTR)(LPCTSTR)colText;
	lcol.cchTextMax = colText.GetLength();

	while( m_listPorts.GetColumn( i , &lcol) )
	{
		tsize = cdc->GetOutputTextExtent(CString(lcol.pszText));
		//tsize.cx = m_listPorts.GetStringWidth(lcol.pszText);

		//colWidth = max(tsize.cx, lcol.cx);
		colWidth = tsize.cx;

		litem.iSubItem = i;

		for(j=0; j< m_listPorts.GetItemCount(); j++)
		{
			litem.iItem = j;
			m_listPorts.GetItem( &litem );

			tsize = cdc->GetOutputTextExtent(CString(litem.pszText));
			//tsize.cx = m_listPorts.GetStringWidth(litem.pszText);

			if (tsize.cx > colWidth) colWidth = tsize.cx;
		}

		m_listPorts.SetColumnWidth( i, colWidth );

		i++;
	}

	ReleaseDC(cdc);
}





void CMain::OnCmdAbout() 
{
	((CSerialRedirectApp *)AfxGetApp())->OnAppAbout();	
}
