/*
 * Decompiled with CFR 0.152.
 */
package netbios;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class InetAddressUtil {
    public static InetAddress getMask(byte[] byArray, int n2) throws UnknownHostException {
        byte[] byArray2 = new byte[4];
        if (byArray[n2] == 0) {
            throw new UnknownHostException();
        }
        byArray2[0] = -1;
        if ((byArray[n2] & Integer.MIN_VALUE) == 0) {
            return InetAddressUtil.byteToInetAddress(byArray2, 0);
        }
        byArray2[1] = -1;
        if ((byArray[n2] & 0x40) == 0) {
            return InetAddressUtil.byteToInetAddress(byArray2, 0);
        }
        if ((byArray[n2] & 0x20) == 0) {
            byArray2[2] = -1;
            return InetAddressUtil.byteToInetAddress(byArray2, 0);
        }
        throw new UnknownHostException();
    }

    public static InetAddress getBroadcast(byte[] byArray, int n2) throws UnknownHostException {
        byte[] byArray2 = new byte[4];
        byArray2[0] = byArray[n2];
        if ((byArray[n2] & Integer.MIN_VALUE) == 0) {
            byArray2[1] = -1;
            byArray2[2] = -1;
            byArray2[3] = -1;
            return InetAddressUtil.byteToInetAddress(byArray2, 0);
        }
        byArray2[1] = byArray[n2 + 1];
        if ((byArray[n2] & 0x40) == 0) {
            byArray2[2] = -1;
            byArray2[3] = -1;
            return InetAddressUtil.byteToInetAddress(byArray2, 0);
        }
        if ((byArray[n2] & 0x20) == 0) {
            byArray2[2] = byArray[n2 + 2];
            byArray2[3] = -1;
            return InetAddressUtil.byteToInetAddress(byArray2, 0);
        }
        throw new UnknownHostException();
    }

    public static InetAddress getLocalBroadcast() throws UnknownHostException {
        byte[] byArray = InetAddress.getLocalHost().getAddress();
        return InetAddressUtil.getBroadcast(byArray, 0);
    }

    public static InetAddress byteToInetAddress(byte[] byArray, int n2) throws UnknownHostException {
        StringBuffer stringBuffer = new StringBuffer(15);
        int n3 = 0;
        while (n3 < 4) {
            int n4 = byArray[n2 + n3] & 0x7F;
            if ((byArray[n2 + n3] & 0x4C4B400) != 0) {
                n4 |= 0x80;
            }
            stringBuffer.append(n4);
            if (n3 != 3) {
                stringBuffer.append('.');
            }
            ++n3;
        }
        return InetAddress.getByName(stringBuffer.toString());
    }
}

