/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class KunststoffMenuUI
extends BasicMenuUI {
    public static ComponentUI createUI(JComponent x2) {
        return new KunststoffMenuUI();
    }

    public void paint(Graphics g2, JComponent c2) {
        super.paint(g2, c2);
        Container parent = this.menuItem.getParent();
        if (c2.isOpaque() && parent != null && parent instanceof JMenuBar) {
            ColorUIResource colorShadow;
            Point loc = c2.getLocation();
            Graphics2D g2D = (Graphics2D)g2;
            ColorUIResource colorReflection = KunststoffLookAndFeel.getComponentGradientColorReflection();
            if (colorReflection != null) {
                Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor(colorReflection, 0);
                Rectangle drawRect = new Rectangle(0, 0, parent.getWidth(), parent.getHeight() / 2);
                Rectangle gradRect = new Rectangle(0, -loc.y, parent.getWidth(), parent.getHeight() / 2);
                KunststoffUtilities.drawGradient(g2, colorReflection, colorReflectionFaded, drawRect, gradRect, true);
            }
            if ((colorShadow = KunststoffLookAndFeel.getComponentGradientColorShadow()) != null) {
                Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
                Rectangle drawRect = new Rectangle(0, parent.getHeight() / 2, parent.getWidth(), parent.getHeight() / 2);
                Rectangle gradRect = new Rectangle(0, parent.getHeight() / 2 - loc.y, parent.getWidth(), parent.getHeight() / 2);
                KunststoffUtilities.drawGradient(g2, colorShadowFaded, colorShadow, drawRect, gradRect, true);
            }
        }
    }
}

