/*
 * Decompiled with CFR 0.152.
 */
package chordsen;

import chordsen.AB;
import chordsen.BE;
import java.util.BitSet;

final class AFM {
    public int maxN;
    public int n;
    public int key;
    public int type;
    BE bExp;
    int actual;
    int[][] accAA;
    AB ab;
    final int[] emptyFBA = new int[]{4, 9, 2, 7, 11, 4};

    public AFM() {
        this(new BE(), 64, new AB());
    }

    public AFM(BE bE, int n, AB aB) {
        this.bExp = bE;
        this.maxN = n;
        this.reset();
        this.type = 0;
        this.key = 0;
        this.accAA = new int[this.maxN][6];
        this.ab = aB;
    }

    boolean add(int[] nArray) {
        if (this.n < this.maxN && nArray.length == 6) {
            System.arraycopy(nArray, 0, this.accAA[this.n++], 0, 6);
            return true;
        }
        return false;
    }

    boolean existNext() {
        return this.n > 0 && this.actual < this.n - 1;
    }

    boolean existPrev() {
        return this.n > 0 && this.actual > 0;
    }

    int[] getActual() {
        return this.accAA[this.actual];
    }

    void newAccord(int n, int n2) {
        this.reset();
        this.key = n;
        this.type = n2;
    }

    boolean next() {
        if (this.existNext()) {
            ++this.actual;
            return true;
        }
        return false;
    }

    boolean onlyAccordsWithPenultTon() {
        int[] nArray = this.ab.getType(this.type);
        int n = (this.key + nArray[nArray.length - 2]) % 12;
        int n2 = 0;
        while (n2 < this.n) {
            if (!this.tonOnStrings(n, this.accAA[n2], 1, 5) && !this.remove(n2--, 6)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    boolean onlyAccordsWithSecondTon() {
        int[] nArray = this.ab.getType(this.type);
        int n = (this.key + nArray[1]) % 12;
        int n2 = 0;
        while (n2 < this.n) {
            if (!this.tonOnStrings(n, this.accAA[n2], 1, 5) && !this.remove(n2--, 6)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    boolean onlyAccordsWithTheFirstAndLastTon() {
        int[] nArray = this.ab.getType(this.type);
        int n = (this.key + nArray[nArray.length - 1]) % 12;
        int n2 = 0;
        while (n2 < this.n) {
            if (!(this.tonOnStrings(this.key, this.accAA[n2], 0, 4) && this.tonOnStrings(n, this.accAA[n2], 2, 5) || this.remove(n2--, 4))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    boolean prev() {
        if (this.existPrev()) {
            --this.actual;
            return true;
        }
        return false;
    }

    boolean remove(int n, int n2) {
        if (n >= 0 && n < this.n && this.n >= n2) {
            System.arraycopy(this.accAA[--this.n], 0, this.accAA[n], 0, 6);
            return true;
        }
        return false;
    }

    void reset() {
        this.actual = 0;
        this.n = 0;
    }

    void setAtFirst() {
        this.actual = 0;
    }

    void sort() {
        int n;
        int n2;
        int[] nArray = new int[this.n];
        int[] nArray2 = new int[6];
        if (this.n < 2) {
            return;
        }
        int n3 = 0;
        while (n3 < this.n) {
            nArray[n3] = 0;
            n2 = Integer.MAX_VALUE;
            n = 0;
            while (n < 6) {
                if (this.accAA[n3][n] > 0) {
                    nArray[n3] = n2 = Math.min(this.accAA[n3][n], n2);
                }
                ++n;
            }
            ++n3;
        }
        boolean bl = true;
        n3 = this.n - 1;
        while (bl && n3 > 0) {
            bl = false;
            n = 0;
            while (n < n3) {
                if (nArray[n] > nArray[n + 1]) {
                    n2 = nArray[n];
                    nArray[n] = nArray[n + 1];
                    nArray[n + 1] = n2;
                    System.arraycopy(this.accAA[n], 0, nArray2, 0, 6);
                    System.arraycopy(this.accAA[n + 1], 0, this.accAA[n], 0, 6);
                    System.arraycopy(nArray2, 0, this.accAA[n + 1], 0, 6);
                    bl = true;
                }
                ++n;
            }
            --n3;
        }
    }

    boolean tonOnStrings(int n, int[] nArray, int n2, int n3) {
        BitSet bitSet = new BitSet(12);
        int n4 = n2;
        while (n4 <= n3) {
            if (nArray[n4] >= 0) {
                bitSet.set((this.emptyFBA[n4] + nArray[n4]) % 12);
            }
            ++n4;
        }
        return bitSet.get(n);
    }
}

