import java.awt.*;
import java.applet.*;
public class Grapher extends Applet
{
	int w,h,count,points;
	int xAxes,yAxes,xScaleFactor,yScaleFactor;
	float xmin,xmax,ymax;
	float xscale,yscale;
	float scaleX;
	float X[],Y[];
	boolean Grid=true;
	boolean	allowMouse=true;
	int view=0;
	Rectangle first,second,third,fourth;
	
	public void init()
	{
		w=size().width;
		h=size().height;
		setBackground(Color.white);
		setXScale(-10,10,101);
		for(float i=-10;i<=10;i+=0.2)
		{
			try
			{
				addPoint(i,(float)Math.cos(i));
			}
			catch(Exception exp1)
			{}
		}
		setQuadrant(view);
		first=new Rectangle(w/2,0,w/2,h/2);
		second=new Rectangle(0,0,w/2,h/2);
		third=new Rectangle(0,h/2,w/2,h/2);
		fourth=new Rectangle(w/2,h/2,w/2,h/2);
	}

	public void setXScale(float min,float max,int pts)
	{
		reset();
		xmin=min;
		xmax=max;
		points=pts;
		if(Math.abs(xmax)>Math.abs(xmin))
		{
			scaleX=Math.abs(xmax);
		}
		else
		{
			scaleX=Math.abs(xmin);
		}
		xmax=scaleX;
		XScale();
		X=new float[points];
		Y=new float[points];
	}

	void XScale()
	{
		xscale=Math.abs((xScaleFactor-20)/scaleX);
	}
	
	public void addPoint(float x,float y)
	{
		X[count]=x;
		Y[count]=y;
		count++;
	}

	public void changeGrid()
	{
		Grid=!Grid;
		repaint();
	}
	
	public void changeView()
	{
		view++;
		if(view>8) view=0;
		setQuadrant(view);
		repaint();
	}
	
	public void paint(Graphics g)
	{
		drawGraph(g);
	}
	
	public void setQuadrant(int quad)
	{
		view=quad;
		if(quad==0)
			{
				xAxes=w/2;
				yAxes=h/2;
			}
		if(quad==1)
			{
				xAxes=20;
				yAxes=h-20;
			}
		if(quad==2)
			{
				xAxes=w-20;
				yAxes=h-20;
			}
		if(quad==3)
			{
				xAxes=w-20;
				yAxes=20;
			}
		if(quad==4)
			{
				xAxes=20;
				yAxes=20;
			}
		if(quad==5)
			{
				xAxes=20;
				yAxes=h/2;
			}
		if(quad==6)
			{
				xAxes=w/2;
				yAxes=h-20;
			}
		if(quad==7)
			{
				xAxes=w-20;
				yAxes=h/2;
			}
		if(quad==8)
			{
				xAxes=w/2;
				yAxes=20;
			}
		setScaleFactor(quad);
		XScale();
		repaint();
	}
	
	void setScaleFactor(int i)
	{
		if(i==1 || i==2 || i==3 || i==4)
		{
			xScaleFactor=w-20;
			yScaleFactor=h-20;
		}
		if(i==0)
			{
				yScaleFactor=h/2;
				xScaleFactor=w/2;
			}
		if(i==5)
			{
				xScaleFactor=w-20;
				yScaleFactor=h/2;
			}
		if(i==6)
			{
				xScaleFactor=w/2;
				yScaleFactor=h-20;
			}
		if(i==7)
			{
				xScaleFactor=w-20;
				yScaleFactor=h/2;
			}
		if(i==8)
			{
				xScaleFactor=w/2;
				yScaleFactor=h-20;
			}
	}

	void drawAxes(Graphics g)
	{
		g.setColor(Color.red);
		for(int i=-1;i<2;i++)
		{
			g.drawLine(xAxes+i,0,xAxes+i,h);
			g.drawLine(0,yAxes+i,w,yAxes+i);
		}
		g.setColor(Color.black);
	}

	void drawGrid(Graphics g)
	{
		String s;

		//Vertical Grid Lines

		for(float j=-xmax;j<xmax+xmax/10;j+=xmax/10)
		{
			g.setColor(Color.green);
			g.drawLine((int)(j*xscale)+xAxes,0,(int)(j*xscale)+xAxes,h);

			g.setColor(Color.black);
			try
			{
				float f1=j;
				s=String.valueOf(f1);
				if(s.length()>5)
				{
					if(f1<0)
					{
						s=s.substring(0,5);
					}
					else
					{
						s=s.substring(0,4);
					}
				}

			}
			catch(Exception exp3)
			{
				s="0.00";
			}
			g.drawString(s,(int)(j*xscale)+xAxes-10,h-5);
		}

		//Horizontal Grid Lines

		for(int i=h/20;i<h;i+=h/20)
		{
			g.setColor(Color.green);
			g.drawLine(0,i,w,i);

			g.setColor(Color.black);
			try
			{
				float f1=(yAxes-i)/yscale;
				s=String.valueOf(f1);
				if(s.length()>5)
				{
					if(f1<0)
					{
						s=s.substring(0,5);
					}
					else
					{
						s=s.substring(0,4);
					}
				}

			}
			catch(Exception exp3)
			{
				s="0.00";
			}
			g.drawString(s,w-30,i);
		}
	}
	
	void reset()
	{
		X=null;
		Y=null;
		points=0;
		count=0;
	}

	public void allowClick(boolean ans)
	{
		allowMouse=ans;
	}

	void drawGraph(Graphics g)
	{
		ymax=0;
		for(int i=0;i<points;i++)
		{
			if(ymax<Math.abs(Y[i]))
			{
				ymax=Math.abs(Y[i]);
			}
		}
		yscale=Math.abs((yScaleFactor-20)/ymax);

		if(Grid) drawGrid(g);
		drawAxes(g);

		float x0=X[0];
		float y0=Y[0];
		for(int i=1;i<points;i++)
		{
			g.setColor(Color.blue);
			g.drawLine((int)(x0*xscale)+xAxes,(int)(yAxes-y0*yscale),(int)(X[i]*xscale)+xAxes,yAxes-(int)(Y[i]*yscale));
			x0=X[i];
			y0=Y[i];
		}
	}

	public boolean handleEvent(Event e)
	{
		if(e.id==Event.MOUSE_DOWN && allowMouse)
		{
			if(view==0)
			{
				if(first.inside(e.x,e.y)) view=1;
				if(second.inside(e.x,e.y)) view=2;
				if(third.inside(e.x,e.y)) view=3;
				if(fourth.inside(e.x,e.y)) view=4;
			}
			else
			{
				view=0;
			}
			setQuadrant(view);
			repaint();
			return true;
		}
		return super.handleEvent(e);
	}

}

