/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.applet.Applet;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import tools.BaseApplet;
import tools.Problem;
import tools.TestMonitor;
import tools.Tree;
import tools.TypeConverter;

public final class TestReportGenerator
extends Applet
implements Runnable {
    static boolean Sun = System.getProperty("java.vendor").indexOf("Sun") != -1;
    static final String propsFile = "/test/report.txt";
    static Hashtable props = null;
    StringBuffer sb;
    boolean ready;
    int level;
    String text;
    long time;
    int c_;
    int r_;
    int[] c = new int[4];
    int[] r = new int[4];

    public String generateReport() {
        if (Sun) {
            while (!this.ready) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            this._generateReport();
        }
        return this.sb.toString();
    }

    public void init() {
        super.init();
        this.ready = false;
        Color color = TypeConverter.parseColor(this.getParameter("bgcolor"), Color.lightGray);
        this.setBackground(color);
    }

    public void start() {
        this.ready = false;
        if (Sun) {
            new Thread(this).start();
        }
    }

    public void run() {
        this._generateReport();
    }

    synchronized void _generateReport() {
        try {
            if (props == null) {
                props = this.readProps(propsFile);
            }
            this.sb = new StringBuffer(8192);
            this.sb.append(this.parse((String)props.get("Header")));
            this.processTopics();
            this.sb.append(this.parse((String)props.get("Footer")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.sb = new StringBuffer();
            this.sb.append("<h1>Error</h1>");
        }
        this.ready = true;
    }

    void processTopics() {
        Tree tree = Tree.subtree;
        if (tree == null) {
            return;
        }
        tree.resetProblemsIndeces();
        Tree.setIndeces(TestMonitor.problems);
        this.level = 0;
        this.processTopic(tree);
    }

    void processTopic(Tree tree) {
        if (tree.getDepth() < 2 && this.level > 0) {
            return;
        }
        if (!tree.hasIndexedProblems()) {
            return;
        }
        tree.getText();
        this.time = 0L;
        this.c_ = 0;
        this.r_ = 0;
        int n = 0;
        while (n < 4) {
            this.c[n] = 0;
            this.r[n] = 0;
            ++n;
        }
        this.geatherFields(tree);
        while ((this.text = tree.getText()) == null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                this.text = "?";
                break;
            }
        }
        this.sb.append(String.valueOf(this.parse((String)props.get("Topic"))) + "\n");
        if (tree.nodes != null) {
            ++this.level;
            Enumeration enumeration = tree.nodes.elements();
            while (enumeration.hasMoreElements()) {
                this.processTopic((Tree)enumeration.nextElement());
            }
            --this.level;
        }
    }

    void geatherFields(Tree tree) {
        int n;
        if (tree instanceof Problem && (n = ((Problem)tree).index) != -1) {
            this.time += TestMonitor.problemsTime[n];
            boolean bl = TestMonitor.problemsStatus[n] == 2;
            int n2 = ((Problem)tree).compl - 1;
            ++this.c_;
            int n3 = n2;
            this.c[n3] = this.c[n3] + 1;
            if (bl) {
                ++this.r_;
                int n4 = n2;
                this.r[n4] = this.r[n4] + 1;
            }
        }
        if (tree.nodes != null) {
            Enumeration enumeration = tree.nodes.elements();
            while (enumeration.hasMoreElements()) {
                this.geatherFields((Tree)enumeration.nextElement());
            }
        }
    }

    String parse(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(512);
        int n = 0;
        while (n < string.length()) {
            int n2;
            char c = string.charAt(n);
            if (c == '{' && (n2 = string.indexOf("}", n)) != -1) {
                String string2 = string.substring(n + 1, n2).trim();
                stringBuffer.append(this.getField(string2));
                n = n2;
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    String getField(String string) {
        if ("NAME".equals(string)) {
            return TestMonitor.name;
        }
        if ("DATE".equals(string)) {
            return String.valueOf(new Date().getDate());
        }
        if ("MONTH".equals(string)) {
            return String.valueOf(new Date().getMonth() + 1);
        }
        if ("YEAR".equals(string)) {
            return String.valueOf(new Date().getYear() + 1900);
        }
        if ("TEXT".equals(string)) {
            String string2 = "";
            int n = 0;
            while (n < this.level) {
                string2 = String.valueOf(string2) + "&nbsp;&nbsp;&nbsp;";
                ++n;
            }
            return String.valueOf(string2) + this.text;
        }
        if ("TIME".equals(string)) {
            return TestMonitor.t2s(this.time, 0);
        }
        if ("RIGHT".equals(string)) {
            if (this.c_ == 0) {
                return "&nbsp;";
            }
            return String.valueOf(this.r_);
        }
        if (string.startsWith("RIGHT")) {
            int n = Integer.valueOf(string.substring(5)) - 1;
            if (this.c[n] == 0) {
                return "&nbsp;";
            }
            return String.valueOf(this.r[n]);
        }
        if ("COUNT".equals(string)) {
            if (this.c_ == 0) {
                return "&nbsp;";
            }
            return String.valueOf(this.c_);
        }
        if (string.startsWith("COUNT")) {
            int n = Integer.valueOf(string.substring(5)) - 1;
            if (this.c[n] == 0) {
                return "&nbsp;";
            }
            return String.valueOf(this.c[n]);
        }
        if ("PERCENT".equals(string)) {
            if (this.c_ == 0) {
                return "&nbsp;";
            }
            return String.valueOf((int)((double)this.r_ / (double)this.c_ * 100.0 + 0.5));
        }
        if (string.startsWith("PERCENT")) {
            int n = Integer.valueOf(string.substring(7)) - 1;
            if (this.c[n] == 0) {
                return "&nbsp;";
            }
            return String.valueOf((int)((double)this.r[n] / (double)this.c[n] * 100.0 + 0.5));
        }
        return "";
    }

    Hashtable readProps(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        BufferedReader bufferedReader = null;
        try {
            try {
                URL uRL = BaseApplet.makeURL(string);
                if (uRL == null) {
                } else {
                    String string2;
                    URLConnection uRLConnection = uRL.openConnection();
                    bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                    String string3 = "noname";
                    StringBuffer stringBuffer = null;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (string2.startsWith("#")) {
                            if (stringBuffer != null) {
                                hashtable.put(string3, new String(stringBuffer));
                            }
                            string3 = string2.substring(1).trim();
                            stringBuffer = null;
                            continue;
                        }
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer(1024);
                        }
                        stringBuffer.append(string2);
                    }
                    if (stringBuffer != null) {
                        hashtable.put(string3, new String(stringBuffer));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (Exception exception) {}
        return hashtable;
    }
}

