#include "mcadincl.h"
    
CUFPROC CreateUserFunction;
CUEMTPROC CreateUserErrorMessageTable;
MAAPROC MathcadArrayAllocate;
MAFPROC MathcadArrayFree;
MAPROC MathcadAllocate;
MFPROC MathcadFree;
ISIPROC isUserInterrupted;
    

    extern FUNCTIONINFO H1v,H2v,Jvc,Yvc,Ivc,Kvc,jsph,ysph,h1sph,h2sph,Ai,Bi,Aip,Bip,struvec;
    extern FUNCTIONINFO H1e,H2e,Jve,Yve,Ive,Kve,Aie,Bie,Aipe,Bipe;
    extern FUNCTIONINFO lg,rgam,binomial,Beta1,lbeta1,psic,igamma,igammac,igammai,ibeta,ibetai;
    extern FUNCTIONINFO hyp1c1,hyp2c0,hyp2c1,hyp1c2,hyp3c0;
    extern FUNCTIONINFO LegE,LegF,LegEc,LegEc1,LegKc,LegKc1,sn,cn,dn,phi;
    extern FUNCTIONINFO LegP,LegPc,LegPc1,Rf,Rd,Rj;
    extern FUNCTIONINFO Dawson,FresnelC,FresnelS,dilog,Riezeta,Riezeta2;
    extern FUNCTIONINFO expint,sinint,cosint,sinhint,coshint,Plm,Qlm,pnorm,Ylm,Yl;
    extern FUNCTIONINFO arrot,signum,csgn,sfact,mask;

    char *ErrorMessageTable[] = {
    "argument must be real",    //  error 1 --  argument must be real
    "insufficient memory",      //  error 2 --  memory allocation error
    "interrupted",              //  error 3 --  execution interrupted
    "unknown",                  //  error 4
    "domain",                   //  error 5
    "singularity",              //  error 6
    "overflow",                 //  error 7
    "underflow",                //  error 8
    "total loss of precision",  //  error 9
    "partial loss of precision",//  error 10
    "argument must be integer", //  error 11
    "not converging"            //  error 12 
    };


int APIENTRY LibMain(HANDLE hDLL, DWORD dwReason, LPVOID lpReserved)
{
  switch (dwReason)
  {
    case DLL_PROCESS_ATTACH:
    {

      // DLL is attaching to the address space of the current process.
      //
        HINSTANCE  hinstLib=LoadLibrary("mcaduser.dll");
        
        if(hinstLib!=NULL){
            CreateUserFunction = (CUFPROC) GetProcAddress(hinstLib,"CreateUserFunction");
            CreateUserErrorMessageTable=(CUEMTPROC) GetProcAddress(hinstLib,"CreateUserErrorMessageTable");
            MathcadArrayAllocate=(MAAPROC )GetProcAddress(hinstLib,"MathcadArrayAllocate");
            MathcadArrayFree=(MAFPROC )GetProcAddress(hinstLib,"MathcadArrayFree");
            MathcadAllocate=(MAPROC )GetProcAddress(hinstLib,"MathcadAllocate");
            MathcadFree=(MFPROC )GetProcAddress(hinstLib,"MathcadFree");
            isUserInterrupted=(ISIPROC )GetProcAddress(hinstLib,"isUserInterrupted");

            if (CreateUserErrorMessageTable == NULL ||
                 CreateUserFunction == NULL ||
                 MathcadArrayAllocate == NULL ||
                 MathcadArrayFree == NULL ||
                 MathcadAllocate == NULL ||
                 MathcadFree  == NULL ||
                 isUserInterrupted == NULL) break;

        if (CreateUserErrorMessageTable( hDLL, 12, ErrorMessageTable ) )
           { CreateUserFunction( hDLL, &H1v );
                 CreateUserFunction( hDLL, &H2v );
                 CreateUserFunction( hDLL, &Jvc );
                 CreateUserFunction( hDLL, &Yvc );
                 CreateUserFunction( hDLL, &Ivc );
                 CreateUserFunction( hDLL, &Kvc );
                 CreateUserFunction( hDLL, &jsph );
                 CreateUserFunction( hDLL, &ysph );
                 CreateUserFunction( hDLL, &h1sph );
                 CreateUserFunction( hDLL, &h2sph );
                 CreateUserFunction( hDLL, &Ai );
                 CreateUserFunction( hDLL, &Bi );
                 CreateUserFunction( hDLL, &Aip );
                 CreateUserFunction( hDLL, &Bip );
                 CreateUserFunction( hDLL, &struvec );
                 CreateUserFunction( hDLL, &H1e );
                 CreateUserFunction( hDLL, &H2e );
                 CreateUserFunction( hDLL, &Jve );
                 CreateUserFunction( hDLL, &Yve );
                 CreateUserFunction( hDLL, &Ive );
                 CreateUserFunction( hDLL, &Kve );
                 CreateUserFunction( hDLL, &Aie );
                 CreateUserFunction( hDLL, &Bie );
                 CreateUserFunction( hDLL, &Aipe );
                 CreateUserFunction( hDLL, &Bipe );
                 CreateUserFunction( hDLL, &lg );
                 CreateUserFunction( hDLL, &rgam );
                 CreateUserFunction( hDLL, &binomial );
                 CreateUserFunction( hDLL, &Beta1 );
                 CreateUserFunction( hDLL, &lbeta1 );
                 CreateUserFunction( hDLL, &psic );
                 CreateUserFunction( hDLL, &igamma );
                 CreateUserFunction( hDLL, &igammac );
                 CreateUserFunction( hDLL, &igammai );
                 CreateUserFunction( hDLL, &ibeta );
                 CreateUserFunction( hDLL, &ibetai );
                 CreateUserFunction( hDLL, &hyp1c1 );
                 CreateUserFunction( hDLL, &hyp2c0 );
                 CreateUserFunction( hDLL, &hyp2c1 );
                 CreateUserFunction( hDLL, &hyp1c2 );
                 CreateUserFunction( hDLL, &hyp3c0 );
                 CreateUserFunction( hDLL, &LegE );
                 CreateUserFunction( hDLL, &LegF );
                 CreateUserFunction( hDLL, &LegEc );
                 CreateUserFunction( hDLL, &LegEc1 );
                 CreateUserFunction( hDLL, &LegKc );
                 CreateUserFunction( hDLL, &LegKc1 );
                 CreateUserFunction( hDLL, &LegP );
                 CreateUserFunction( hDLL, &LegPc );
                 CreateUserFunction( hDLL, &LegPc1 );
                 CreateUserFunction( hDLL, &Rf );
                 CreateUserFunction( hDLL, &Rd );
                 CreateUserFunction( hDLL, &Rj );
                 CreateUserFunction( hDLL, &sn );
                 CreateUserFunction( hDLL, &cn );
                 CreateUserFunction( hDLL, &dn );
                 CreateUserFunction( hDLL, &phi );
                 CreateUserFunction( hDLL, &Dawson );
                 CreateUserFunction( hDLL, &FresnelC );
                 CreateUserFunction( hDLL, &FresnelS );
                 CreateUserFunction( hDLL, &dilog );
                 CreateUserFunction( hDLL, &Riezeta );
                 CreateUserFunction( hDLL, &Riezeta2 );
                 CreateUserFunction( hDLL, &expint );
                 CreateUserFunction( hDLL, &sinint );
                 CreateUserFunction( hDLL, &cosint );
                 CreateUserFunction( hDLL, &sinhint );
                 CreateUserFunction( hDLL, &coshint );
                 CreateUserFunction( hDLL, &Plm );
                 CreateUserFunction( hDLL, &Qlm );
                 CreateUserFunction( hDLL, &pnorm );
                 CreateUserFunction( hDLL, &Ylm );
                 CreateUserFunction( hDLL, &Yl );
                 CreateUserFunction( hDLL, &arrot );
                 CreateUserFunction( hDLL, &signum );
                 CreateUserFunction( hDLL, &csgn );
                 CreateUserFunction( hDLL, &sfact );
                 CreateUserFunction( hDLL, &mask );
           }
    }
    }        
        break;

    case DLL_THREAD_ATTACH:        // A new thread is being created in the current process.
    case DLL_THREAD_DETACH:        // A thread is exiting cleanly.
    case DLL_PROCESS_DETACH:      // The calling process is detaching the DLL from its address space.

      break;
  }
  return TRUE;
}

    

