/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command;

import X10Gimli.Command.BeginCommand;
import X10Gimli.Command.Command;
import X10Gimli.Command.FuncCommand;
import X10Gimli.Command.Function.X10addressCommand;
import X10Gimli.Command.Function.X10commandCommand;
import X10Gimli.Command.TriggerCommand;
import X10Gimli.System.Environment;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.System.Trigger;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueCommand;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueOp;
import X10Gimli.Value.ValueTime;
import X10Gimli.Value.ValueType;
import X10Gimli.Value.ValueX10;
import java.util.ArrayList;
import java.util.Calendar;

public final class MotionCommand
extends Command {
    private ValueType vtID;
    private ValueType vtTime;
    private Command cStartCommand;
    private Command cFinishCommand;

    public MotionCommand() {
        this.vtID = new ValueX10('A', 1);
        this.defaultTime();
    }

    public MotionCommand(ValueType id, ValueType time, Command start, Command finish) {
        this.setID(id);
        this.setTime(time);
        this.setStartCommand(start);
        this.setFinishCommand(finish);
    }

    private void defaultTime() {
        this.vtTime = new ValueNumber(60);
    }

    private Command defaultX10StartCommand() {
        BeginCommand begin = new BeginCommand();
        ArrayList<FuncCommand> initcommands = new ArrayList<FuncCommand>();
        ArrayList<ValueType> params1 = new ArrayList<ValueType>();
        params1.add(this.vtID);
        X10addressCommand comm1 = new X10addressCommand();
        comm1.setCommand("X10ADDRESS");
        comm1.setParams(params1);
        initcommands.add(comm1);
        ArrayList<ValueType> params2 = new ArrayList<ValueType>();
        params2.add(new ValueCommand("ON"));
        params2.add(this.vtID);
        X10commandCommand comm2 = new X10commandCommand();
        comm2.setCommand("X10COMMAND");
        comm2.setParams(params2);
        initcommands.add(comm2);
        begin.setCommands(initcommands);
        return begin;
    }

    private Command defaultX10FinishCommand() {
        BeginCommand begin = new BeginCommand();
        ArrayList<FuncCommand> exitcommands = new ArrayList<FuncCommand>();
        ArrayList<ValueType> params1 = new ArrayList<ValueType>();
        params1.add(this.vtID);
        X10addressCommand comm1 = new X10addressCommand();
        comm1.setCommand("X10ADDRESS");
        comm1.setParams(params1);
        exitcommands.add(comm1);
        ArrayList<ValueType> params2 = new ArrayList<ValueType>();
        params2.add(new ValueCommand("OFF"));
        params2.add(this.vtID);
        X10commandCommand comm2 = new X10commandCommand();
        comm2.setCommand("X10COMMAND");
        comm2.setParams(params2);
        exitcommands.add(comm2);
        begin.setCommands(exitcommands);
        return begin;
    }

    public void setID(ValueType id) {
        this.vtID = id;
    }

    public void setTime(ValueType time) {
        this.vtTime = time;
    }

    public void setStartCommand(Command start) {
        this.cStartCommand = start;
    }

    public void setFinishCommand(Command finish) {
        this.cFinishCommand = finish;
    }

    public ValueType getID() {
        return this.vtID;
    }

    public ValueType getTime() {
        return this.vtTime;
    }

    public Command getStartCommand() {
        return this.cStartCommand;
    }

    public Command getFinishCommand() {
        return this.cFinishCommand;
    }

    public ValueType execute(EnvironmentSmall env) {
        if (env != null && env.getFullEnvironment() != null) {
            Value val;
            Environment fullenv = env.getFullEnvironment();
            Trigger t = fullenv.findTrigger((val = this.vtID.getValue(env)).toString());
            if (t != null) {
                ValueOp c = (ValueOp)t.getCase();
                c.setRight(new ValueTime(Calendar.getInstance()).applyOperation("+", this.vtTime, env));
            } else {
                t = new Trigger();
                t.setName(val.toString());
                t.setCase(new ValueOp(ValueIdent.getPreDefined("TIME"), "==", new ValueTime(Calendar.getInstance()).applyOperation("+", this.vtTime, env)));
                if (this.cFinishCommand == null && val instanceof ValueX10) {
                    t.setCommand(this.defaultX10FinishCommand());
                } else if (this.cFinishCommand == null) {
                    t.setCommand(new BeginCommand());
                } else {
                    t.setCommand(this.cFinishCommand);
                }
                if (this.cStartCommand == null && val instanceof ValueX10) {
                    env.executeCommand(this.defaultX10StartCommand());
                } else if (this.cStartCommand != null) {
                    env.executeCommand(this.cStartCommand);
                }
                fullenv.addLocalTrigger(t);
            }
        }
        return null;
    }

    protected void executionOutput() {
        this.sBuf.append("motion ");
        this.sBuf.append(this.vtID.string);
        this.sBuf.append(" ");
        this.sBuf.append(this.vtTime.string);
    }

    public String toX10GIMLI(int depth) {
        block6: {
            char[] sBytes = new char[500];
            for (int i = 0; i < 500; ++i) {
                sBytes[i] = 32;
            }
            int indent = depth * 2;
            this.prepareOutputDepth(depth);
            this.sBuf.append("motion ");
            this.sBuf.append(this.vtID.toX10GIMLI());
            this.sBuf.append(" ");
            this.sBuf.append(this.vtTime.toX10GIMLI());
            this.sBuf.append(";\n");
            if (this.cStartCommand != null) {
                this.sBuf.append(sBytes, 0, indent + 2);
                this.sBuf.append("start");
                if (this.cStartCommand instanceof BeginCommand || this.cStartCommand instanceof MotionCommand || this.cStartCommand instanceof TriggerCommand) {
                    this.sBuf.append("\n");
                    this.sBuf.append(this.cStartCommand.toX10GIMLI(depth + 2));
                } else {
                    this.sBuf.append(" ");
                    this.sBuf.append(this.cStartCommand.toX10GIMLI(0));
                }
            }
            if (this.cFinishCommand == null) break block6;
            this.sBuf.append(sBytes, 0, indent + 2);
            this.sBuf.append("finish");
            if (this.cFinishCommand instanceof BeginCommand || this.cFinishCommand instanceof MotionCommand || this.cFinishCommand instanceof TriggerCommand) {
                this.sBuf.append("\n");
                this.sBuf.append(this.cFinishCommand.toX10GIMLI(depth + 2));
            } else {
                this.sBuf.append(" ");
                this.sBuf.append(this.cFinishCommand.toX10GIMLI(0));
            }
        }
        return this.sBuf.toString();
    }
}

