/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command;

import X10Gimli.Command.Command;
import X10Gimli.Debug;
import X10Gimli.System.Definition;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueType;

public final class ForCommand
extends Command {
    private String id = "loop";
    private ValueType low;
    private ValueType high;
    private Command command;

    public void setIdentifier(String i) {
        this.id = i.toUpperCase().intern();
    }

    public void setLowValue(ValueType l) {
        this.low = l;
    }

    public void setHighValue(ValueType h) {
        this.high = h;
    }

    public void setCommand(Command c) {
        this.command = c;
    }

    public String getIdentifier() {
        return this.id;
    }

    public ValueType getLowValue() {
        return this.low;
    }

    public ValueType getHighValue() {
        return this.high;
    }

    public Command getCommand() {
        return this.command;
    }

    public ValueType execute(EnvironmentSmall env) {
        if (env != null) {
            EnvironmentSmall exe = env.spawnEnvironment();
            Value l = this.low.getValue(env);
            Value h = this.high.getValue(env);
            if (l instanceof ValueNumber && h instanceof ValueNumber) {
                Definition d = new Definition(this.id, null);
                exe.addDefinition(d);
                int lnum = l.getNumber();
                int hnum = h.getNumber();
                if (lnum > hnum) {
                    int t = lnum;
                    lnum = hnum;
                    hnum = t;
                }
                for (int i = lnum; i <= hnum; ++i) {
                    d.setValue(new ValueNumber(i));
                    exe.setDefinition(d);
                    exe.executeCommand(this.command);
                }
            } else {
                Debug.error("(Runtime) The range values do not evaluate to numbers.");
            }
        }
        return null;
    }

    protected void executionOutput() {
        this.sBuf.append("for ");
        this.sBuf.append(this.id);
        this.sBuf.append(" = ");
        this.sBuf.append(this.low.string);
        this.sBuf.append(" to ");
        this.sBuf.append(this.high.string);
    }

    public String toX10GIMLI(int depth) {
        this.prepareOutputDepth(depth);
        this.sBuf.append("for ");
        this.sBuf.append(this.id);
        this.sBuf.append(" = ");
        this.sBuf.append(this.low.toX10GIMLI());
        this.sBuf.append(" to ");
        this.sBuf.append(this.high.toX10GIMLI());
        this.sBuf.append(" do\r\n");
        this.sBuf.append(this.command.toX10GIMLI(depth + 1));
        return this.sBuf.toString();
    }
}

