

// import the WebMacro servlet classes
import org.webmacro.servlet.*;

// import the WebMacro template classes
import org.webmacro.engine.*;

// import the WebMacro broker classes 
import org.webmacro.broker.*;

/**
  * HelloWorld -- the simplest possible WebMacro servlet.
  * The easiest way to create a WebMacro servlet is to
  * subclass from org.webmacro.servlet.WMServlet
  *
  * Before trying to run this example, be sure to do
  * all of the following:
  *
  *   1.  Add webmacro.jar to your CLASSPATH
  *
  *   2.  Compile this servlet and install it in your servlet directory
  *
  *   3.  Add webmacro.jar to your servlet runner's classpath,
  *       and put webmacro.properties in the same place
  *
  *   4.  Edit webmacro.properties to configure WebMacro for your setup
  *
  *   5.  Start your servlet runner
  *
  */
public class HelloWorld extends WMServlet
{

   /**
     * WebMacro creates a WebContext and passes it to your servlet. 
     * The WebContext contains all the information you'll need to 
     * handle the request. It is also the only object you share 
     * with the template. If you add objects to the WebContext via
     * its put(key,value)method,they become available in the 
     * template as variables named after the key.
     */
   public Template handle(WebContext context) 
      throws HandlerException
   {

      // Put whatever data you like into the context. In
      // this example we just put in a simple string

      context.put("Hello", "Hello, brave new world!");


      // Select a template. You could choose the template based 
      // on any criteria you like: user preference, current 
      // action, different templates for different results, etc.

      // Here we always return exactly the same template.
      Template view;

      try {

         // The following line asks WebMacro's resource broker to
         // find the "helloWorld.wm" template, cache it, and return a 
         // parsed copy to us.

         view = getTemplate("helloWorld.wm");

      } catch (ResourceUnavailableException e) {

         // If this happens you have not set WebMacro up correctly:

         throw new HandlerException(
              "HelloWorld loaded and executed OK, but was unable to load \n"
            + "a template. There are a couple of things that could be wrong \n"
            + "here. First, you may have put webmacro.properties somewhere \n"
            + "outside your servlet classpath. Try putting it in the same \n"
            + "place as you put webmacro.jar. Second, you may have set the \n"
            + "TemplateRoot directory incorectly. The file helloWorld.wm \n"
            + "must be in one of the directories listed in that option in \n"
            + "the webmacro.properties file. You should check the server \n"
            + "logs or output (or WebMacro's log if it's set and being used \n"
            + "for helpful messages which may indicate what the problem is. \n"
            + "Since your servlet runner may have d fewifferent classpath \n"
            + "settings, check that webmacro.properties is in the same \n"
            + "classpath that was used to load webmacro.jar. \n"
            + "\n"
            + "Here is the actual exception that was raised:\n" + e);
      }


      // Return the template selected. WebMacro will combine this
      // with the values in our context and return the result to
      // the user.

      return view;

   }


}

