/*
 * Decompiled with CFR 0.152.
 */
package installator;

import installator.DesignPanel;
import installator.ErrorDialog;
import installator.InstallDialogLast;
import installator.InstallDialogNext;
import installator.InstallatorData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class ProgressDialog
extends JFrame
implements Runnable {
    private static final int XSIZE = 400;
    private static final int YSIZE = 300;
    private static final int TEXT_LEN = 20;
    public InstallatorData installData = null;
    public static final int STEPS_NUMBER = 5;
    JProgressBar prBar = new JProgressBar(0, 5);
    Thread thread;
    JTextField lbl = new JTextField();

    public ProgressDialog(InstallatorData installatorData) {
        this.setTitle("Installation of SMLib");
        this.installData = installatorData;
        this.init();
        this.start();
    }

    private void init() {
        this.lbl.setEditable(false);
        this.lbl.setHorizontalAlignment(0);
        ((Component)this).setSize(new Dimension(400, 300));
        Toolkit toolkit = this.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        ((Component)this).setLocation((dimension.width - 400) / 2, (dimension.height - 300) / 2);
        this.setResizable(false);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new DesignPanel(), "Center");
        jPanel2.setLayout(new GridLayout(2, 1));
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)new JLabel("    "), "South");
        this.getContentPane().add((Component)new JLabel("    "), "West");
        this.getContentPane().add((Component)new JLabel("    "), "East");
        jPanel.add((Component)jPanel2, "South");
        jPanel2.add(this.lbl);
        jPanel2.add(this.prBar);
        this.prBar.setValue(0);
    }

    public void run() {
        this.setCursor(new Cursor(3));
        if (this.thread != null) {
            this.lbl.setText(" java COMM API is being installed ");
            if (!this.installData.installCommAPI()) {
                InstallDialogNext installDialogNext = new InstallDialogNext(this.installData);
                installDialogNext.show();
                this.hide();
                ErrorDialog errorDialog = new ErrorDialog(installDialogNext, "Can't install Comm API because of: ".concat(String.valueOf(String.valueOf(this.installData.errorMessage))));
                errorDialog.show();
                return;
            }
            this.lbl.setText(" SMLib jar is being copied ");
            this.prBar.setValue(1);
            if (!this.installData.installJar()) {
                InstallDialogNext installDialogNext = new InstallDialogNext(this.installData);
                installDialogNext.show();
                this.hide();
                ErrorDialog errorDialog = new ErrorDialog(installDialogNext, "Can't copy SMLib jar file because of: ".concat(String.valueOf(String.valueOf(this.installData.errorMessage))));
                errorDialog.show();
                return;
            }
            this.lbl.setText(" Documentation files are being copied ");
            this.prBar.setValue(2);
            if (!this.installData.installDoc()) {
                InstallDialogNext installDialogNext = new InstallDialogNext(this.installData);
                installDialogNext.show();
                this.hide();
                ErrorDialog errorDialog = new ErrorDialog(installDialogNext, "Can't copy SMLib doc files because of: ".concat(String.valueOf(String.valueOf(this.installData.errorMessage))));
                errorDialog.show();
                return;
            }
            this.lbl.setText(" GUI files are being copied ");
            this.prBar.setValue(3);
            if (!this.installData.installGui()) {
                InstallDialogNext installDialogNext = new InstallDialogNext(this.installData);
                installDialogNext.show();
                this.hide();
                ErrorDialog errorDialog = new ErrorDialog(installDialogNext, "Can't copy SMLib GUI files because of: ".concat(String.valueOf(String.valueOf(this.installData.errorMessage))));
                errorDialog.show();
                return;
            }
            this.lbl.setText(" runGUI.bat file is being written ");
            this.prBar.setValue(4);
            if (!this.installData.writeBat()) {
                InstallDialogNext installDialogNext = new InstallDialogNext(this.installData);
                installDialogNext.show();
                this.hide();
                ErrorDialog errorDialog = new ErrorDialog(installDialogNext, "Can't write bat file because of: ".concat(String.valueOf(String.valueOf(this.installData.errorMessage))));
                errorDialog.show();
                return;
            }
            this.lbl.setText(" Installation is finished ");
            this.prBar.setValue(5);
            this.setCursor(new Cursor(0));
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            InstallDialogLast installDialogLast = new InstallDialogLast(this.installData);
            installDialogLast.show();
            this.hide();
        }
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stop() {
        this.thread = null;
    }

    static {
        XSIZE = 400;
        YSIZE = 300;
        TEXT_LEN = 20;
        STEPS_NUMBER = 5;
    }
}

