package cern.lhcias.csgui.Events;

import java.util.*;
/**
This event is usually sent whenever a list of tags had their values changed in the TagArrays.
*/
public class TagChangeEvent extends java.util.EventObject
{
    Vector tagVector;

    public TagChangeEvent( Object sourceObject) {
        super(sourceObject);
        tagVector = new Vector();
    }

    /** used by the sender of the event
    */
    public void addTag(String tagName){
        tagVector.addElement(tagName);
    }

    public void removeTag(String tagName){
        tagVector.removeElement(tagName);
    }

    /** returns the number of tags which values have changed.
    */
    public int size() {
        return(tagVector.size());
    }

    /** returns the name of the tag at position i
    */
    public String elementAt(int i) {
        return((String) tagVector.elementAt(i));
    }
    
    /** true if tagName has its value changed
    */
    public boolean contains(String tagName) {
        if (tagName != null)
            return(tagVector.contains(tagName));
        else
            return false;
        
    }
}