/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.io.Serializable;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.JCChartBundle;
import jclass.chart.JCChartConverter;
import jclass.chart.JCChartUtil;

public class JCAxisFormula
implements Serializable,
HTMLHandler {
    private JCAxis originator;
    private JCAxis parent;
    double constant;
    double multiplier = 1.0;

    JCAxisFormula() {
    }

    JCAxisFormula(JCAxis jCAxis) {
        this.parent = jCAxis;
    }

    public void setConstant(double d) {
        JCAxisFormula jCAxisFormula = this;
        synchronized (jCAxisFormula) {
            if (this.constant == d) {
                Object var4_3 = null;
                return;
            }
            this.constant = d;
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public double getConstant() {
        return this.constant;
    }

    public void setMultiplier(double d) {
        JCAxisFormula jCAxisFormula = this;
        synchronized (jCAxisFormula) {
            if (this.multiplier == d) {
                Object var4_3 = null;
                return;
            }
            this.multiplier = d;
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public JCAxis getOriginator() {
        return this.originator;
    }

    public void setOriginator(JCAxis jCAxis) {
        JCAxisFormula jCAxisFormula = this;
        synchronized (jCAxisFormula) {
            if (this.originator == jCAxis) {
                Object var3_3 = null;
                return;
            }
            if (this.originator == this.parent) {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key86"));
            }
            this.originator = jCAxis;
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    void calcRelatedParams() {
        double d;
        if (this.originator == null) {
            return;
        }
        if (this.multiplier == 0.0) {
            return;
        }
        double d2 = d = this.multiplier < 0.0 ? -this.multiplier : this.multiplier;
        if (this.parent.isVertical != this.originator.isVertical) {
            this.parent.isVertical = this.originator.isVertical;
            this.parent.setInitialSize();
        }
        this.parent.isReversed = this.originator.isReversed;
        if (this.parent.tickSpacing.isDefault && this.parent.numSpacing.isDefault) {
            this.parent.numSpacing.value = this.originator.numSpacing.value * d;
            this.parent.numSpacing.value = JCChartUtil.precCorrect(this.parent.precision.value, this.parent.numSpacing.value);
            if (this.parent.tickSpacing.isDefault) {
                this.parent.tickSpacing.value = this.parent.numSpacing.value / 2.0;
            }
        } else if (this.parent.tickSpacing.isDefault) {
            this.parent.tickSpacing.value = this.parent.numSpacing.value / 2.0;
        } else if (this.parent.numSpacing.isDefault) {
            this.parent.numSpacing.value = this.parent.tickSpacing.value * 2.0;
        }
        if (this.multiplier > 0.0) {
            if (this.parent.min.isDefault) {
                this.parent.min.value = this.originator.min.value * this.multiplier + this.constant;
            } else if (this.originator.min.isDefault) {
                this.originator.min.value = (this.parent.min.value - this.constant) / this.multiplier;
            }
            if (this.parent.max.isDefault) {
                this.parent.max.value = this.originator.max.value * this.multiplier + this.constant;
                return;
            }
            if (this.originator.max.isDefault) {
                this.originator.max.value = (this.parent.max.value - this.constant) / this.multiplier;
                return;
            }
        } else {
            if (this.parent.max.isDefault) {
                this.parent.max.value = this.originator.min.value * this.multiplier + this.constant;
            } else if (this.originator.max.isDefault) {
                this.originator.max.value = (this.parent.min.value - this.constant) / this.multiplier;
            }
            if (this.parent.min.isDefault) {
                this.parent.min.value = this.originator.max.value * this.multiplier + this.constant;
                return;
            }
            if (this.originator.min.isDefault) {
                this.originator.min.value = (this.parent.max.value - this.constant) / this.multiplier;
            }
        }
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        if (this.originator != null) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".multiplier", this.multiplier);
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".constant", this.constant);
            if (this.parent != null) {
                JCChartConverter jCChartConverter = new JCChartConverter();
                hTMLSaveDriver.writeParam(String.valueOf(string) + ".originator", jCChartConverter.toAxisName(this.parent.getParent(), this.originator.getName(), "xaxis"));
            }
        }
    }

    public void loadParams(String string, JCChart jCChart) {
        this.setMultiplier(JCChart.getConverter().toDouble(jCChart.getParam(String.valueOf(string) + ".multiplier"), this.getMultiplier()));
        this.setConstant(JCChart.getConverter().toDouble(jCChart.getParam(String.valueOf(string) + ".constant"), this.getConstant()));
        JCChartConverter jCChartConverter = new JCChartConverter();
        this.setOriginator(jCChartConverter.toAxis(jCChart, jCChart.getParam(String.valueOf(string) + ".originator"), this.getOriginator()));
    }
}

