/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import jclass.bwt.BWTUtil;
import jclass.bwt.GroupBoxConverter;
import jclass.bwt.JCContainer;
import jclass.util.JCUtilConverter;

public class JCGroupBox
extends JCContainer {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected int shadow = 2;
    int title_align;
    Object title;
    int title_width;
    int title_height;
    Rectangle title_rect = new Rectangle();
    private static final String base = "groupbox";
    private static int nameCounter;
    static final int[] align_values;

    public JCGroupBox() {
        this(null, null);
    }

    public JCGroupBox(Object object) {
        this(null, null);
        this.setTitle(object);
    }

    public JCGroupBox(Applet applet, String string) {
        super(applet, string);
        this.setLayout(new GridLayout(1, 1));
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        if (this.getClass().getName().equals("jclass.bwt.JCGroupBox")) {
            this.getParameters(applet);
        }
    }

    protected void getParameters() {
        super.getParameters();
        GroupBoxConverter.getParams(this);
    }

    public int getShadowThickness() {
        return this.shadow;
    }

    public void setShadowThickness(int n) {
        this.shadow = n;
        this.layout();
        this.repaint();
    }

    public Object getTitle() {
        return this.title;
    }

    public void setTitle(Object object) {
        this.setTitle(object, 0);
    }

    public String getTitleString() {
        if (this.title != null) {
            return this.title.toString();
        }
        return null;
    }

    public void setTitleString(String string) {
        this.setTitle(string, 0);
    }

    public void setTitle(Object object, int n) {
        JCUtilConverter.checkEnum(n, "alignment", align_values);
        this.title = object;
        this.title_align = n;
        this.calcTitleSize();
        this.layout();
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        this.calcTitleSize();
    }

    protected void calcTitleSize() {
        if (this.getPeer() == null) {
            return;
        }
        this.title_width = BWTUtil.getWidth(this.title, this);
        this.title_height = BWTUtil.getHeight(this.title, this);
    }

    public synchronized void layout() {
        if (this.getPeer() == null) {
            return;
        }
        super.layout();
        int n = Math.max(0, this.size().width - 2 * this.shadow);
        int n2 = BWTUtil.isRight(this.title_align) ? this.shadow + n - this.title_width - this.insets().right : (BWTUtil.isCenter(this.title_align) ? this.shadow + (n - this.title_width) / 2 : this.shadow + this.insets().left);
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics();
        this.title_rect.reshape(n2, (fontMetrics.getHeight() - fontMetrics.getAscent()) / 2 - 1, this.title_width, this.title_height);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = bl = this.size().width > 0 && (n3 > this.size().width || n4 > this.size().height);
        if (this.getPeer() != null && this.isShowing() && bl && this.shadow > 0) {
            Graphics graphics = this.getGraphics();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n3, n4);
        }
        super.reshape(n, n2, n3, n4);
        this.layout();
    }

    public Insets insets() {
        Insets insets = super.insets();
        return new Insets(insets.top + Math.max(this.title_height, this.shadow + this.title_height / 2), insets.left + this.shadow, insets.bottom + this.shadow + 2, insets.right + this.shadow + 3);
    }

    protected void drawShadow(Graphics graphics, int n, int n2, int n3, int n4) {
        n4 -= this.shadow;
        n3 -= this.shadow;
        graphics.setColor(BWTUtil.darker(this.getBackground()));
        int n5 = 0;
        while (n5 < this.shadow / 2) {
            graphics.drawRect(n, n2, n3 - 2 * n5 - 3, n4 - 2 * n5 - 3);
            ++n5;
            ++n;
            ++n2;
        }
        graphics.setColor(BWTUtil.brighter(this.getBackground()));
        int n6 = 0;
        while (n6 < this.shadow / 2) {
            graphics.drawRect(n, n2, n3 - 2 * n6 - 3, n4 - 2 * n6 - 3);
            ++n6;
            ++n;
            ++n2;
        }
    }

    protected void drawTitle(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(this.title_rect.x - 1, this.title_rect.y, this.title_rect.width + 2, this.title_rect.height);
        graphics.clipRect(this.shadow, 0, this.size().width - 2 * this.shadow, this.size().height);
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        BWTUtil.draw(this, graphics, this.title, this.title_align, this.title_rect);
    }

    public void paintInterior(Graphics graphics) {
        int n = this.title_height / 2;
        graphics.clearRect(0, 0, this.size().width, this.size().height);
        this.drawShadow(graphics, 0, n, this.size().width, this.size().height - n);
        if (this.title != null) {
            this.drawTitle(graphics);
        }
    }

    protected int preferredWidth() {
        Dimension dimension = super.preferredSize();
        Insets insets = this.insets();
        return Math.max(dimension.width, this.title_width + 4 + insets.left + insets.right);
    }

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        align_values = nArray;
    }
}

