/*
 * Decompiled with CFR 0.152.
 */
package cern.lhcias.csgui.TagsView;

import cern.lhcias.csgui.Events.AlarmAdapter;
import cern.lhcias.csgui.Events.AlarmEvent;
import cern.lhcias.csgui.Events.OpenViewAdapter;
import cern.lhcias.csgui.Events.TagChangeAdapter;
import cern.lhcias.csgui.Events.TagChangeEvent;
import cern.lhcias.csgui.Events.TagClickedAdapter;
import cern.lhcias.csgui.Events.TagClickedEvent;
import cern.lhcias.csgui.Services.configurationMgr;
import cern.lhcias.csgui.Utils.MyUtils;
import cern.lhcias.csgui.Utils.dgslStatement;
import cern.lhcias.csgui.interfaces.AlarmListener;
import cern.lhcias.csgui.interfaces.OpenViewListener;
import cern.lhcias.csgui.interfaces.TagArrays;
import cern.lhcias.csgui.interfaces.TagClickedListener;
import cern.lhcias.csgui.interfaces.TagsView;
import cern.lhcias.csgui.interfaces.tagHistory;
import cern.lhcias.csgui.rtdb.Tag;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;

public class Tagdisplay
extends Canvas
implements TagsView {
    public static final int TEXT_TYPE = 0;
    public static final int LED_TYPE = 1;
    public static final int BAR_TYPE = 2;
    public static final int TREND_TYPE = 3;
    public static final int DIAL_TYPE = 4;
    static final int TYPE_NB = 5;
    private Font textFont = new Font("Helvetica", 1, 18);
    private Font legendFont = new Font("Helvetica", 0, 9);
    private int x_w_begin;
    private int y_w_begin;
    private int w_width;
    private int w_height;
    private int display_type = 0;
    private int x_margin = 10;
    private int y_margin = 5;
    private TagArrays ta;
    private String Tagname = "";
    private boolean IsStatement = false;
    private String Tags;
    TagChangeAdapter Tadapter;
    dgslStatement ip;
    configurationMgr cM;
    Vector myListeners = new Vector();
    Vector myAlarmListeners = new Vector();

    void Tagdisplay_MouseClick(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 0 && this.Tagname.length() > 0) {
            this.fireTagClickedEvent(this.Tagname);
            if (mouseEvent.getClickCount() == 2) {
                this.setNextType();
            }
        }
    }

    public synchronized void addTagClickedListener(TagClickedListener tagClickedListener) {
        this.myListeners.addElement(tagClickedListener);
    }

    public synchronized void removeTagClickedListener(TagClickedListener tagClickedListener) {
        this.myListeners.removeElement(tagClickedListener);
    }

    void fireTagClickedEvent(String string) {
        TagClickedEvent tagClickedEvent = new TagClickedEvent(this);
        tagClickedEvent.setTagName(string);
        int n = 0;
        while (n < this.myListeners.size()) {
            ((TagClickedListener)this.myListeners.elementAt(n)).receiveTagClicked(tagClickedEvent);
            ++n;
        }
    }

    public void addOpenViewListener(OpenViewListener openViewListener) {
    }

    public void removeOpenViewListener(OpenViewListener openViewListener) {
    }

    public void receiveTagChange(TagChangeEvent tagChangeEvent) {
        this.repaint();
    }

    public synchronized void addAlarmListener(AlarmListener alarmListener) {
        this.myAlarmListeners.addElement(alarmListener);
    }

    public synchronized void removeAlarmListener(AlarmListener alarmListener) {
        this.myAlarmListeners.removeElement(alarmListener);
    }

    void fireAlarmEvent(String string, String string2, long l) {
        AlarmEvent alarmEvent = new AlarmEvent(this, string, string2, l);
        int n = 0;
        while (n < this.myAlarmListeners.size()) {
            ((AlarmListener)this.myAlarmListeners.elementAt(n)).receiveAlarm(alarmEvent);
            ++n;
        }
    }

    public void instantiate(TagArrays tagArrays, String string, TagChangeAdapter tagChangeAdapter, TagClickedAdapter tagClickedAdapter, OpenViewAdapter openViewAdapter, configurationMgr configurationMgr2, AlarmAdapter alarmAdapter) {
        this.Tadapter = tagChangeAdapter;
        this.ta = tagArrays;
        this.cM = configurationMgr2;
        SymMouse symMouse = new SymMouse();
        this.addMouseListener(symMouse);
        if (string.startsWith("$")) {
            this.IsStatement = true;
        }
        this.Tagname = string;
        if (!this.IsStatement) {
            if (!this.ta.tagExist(string)) {
                this.ta.addTag(string);
            }
        } else {
            this.ip = new dgslStatement(2, string, this.ta);
            this.Tags = this.ip.getTagNames();
        }
        tagChangeAdapter.subscribeTagList(this, this.getTagNames());
    }

    public void setConfig(String string) {
        if (string.startsWith("component") && (string = MyUtils.get_token(string, 7)) == null) {
            return;
        }
        if (string.startsWith("$")) {
            this.IsStatement = true;
        }
        this.Tagname = string;
        if (!this.IsStatement) {
            if (!this.ta.tagExist(string)) {
                this.ta.addTag(string);
            }
        } else {
            this.ip = new dgslStatement(2, string, this.ta);
            this.Tags = this.ip.getTagNames();
        }
        this.Tadapter.subscribeTagList(this, this.getTagNames());
    }

    public String toString() {
        return this.Tagname;
    }

    public boolean doYouImplement(String string) {
        if (string.equalsIgnoreCase("TEXT_TYPE")) {
            return true;
        }
        if (string.equalsIgnoreCase("LED_TYPE")) {
            return true;
        }
        if (string.equalsIgnoreCase("BAR_TYPE")) {
            return true;
        }
        return string.equalsIgnoreCase("TREND_TYPE");
    }

    public Vector getPossibleTypes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("TEXT_TYPE");
        vector.addElement("LED_TYPE");
        vector.addElement("BAR_TYPE");
        vector.addElement("TREND_TYPE");
        return vector;
    }

    public int getComponentNb() {
        return 0;
    }

    public Vector getComponentsList() {
        return null;
    }

    public Vector getLocalTagNames() {
        return this.getTagNames();
    }

    public String getType() {
        switch (this.display_type) {
            case 0: {
                return "TEXT_TYPE";
            }
            case 1: {
                return "LED_TYPE";
            }
            case 2: {
                return "BAR_TYPE";
            }
            case 3: {
                return "TREND_TYPE";
            }
        }
        return "UNKNOWN_TYPE";
    }

    public Vector getTagNames() {
        if (!this.IsStatement) {
            Vector<String> vector = new Vector<String>();
            vector.addElement(this.Tagname);
            return vector;
        }
        Vector vector = this.ip.getTagNamesAsVector();
        return vector;
    }

    public void setProperty(String string, String string2, String string3) {
        if (string2.equalsIgnoreCase("DISPLAY_TYPE")) {
            if (string3.equalsIgnoreCase("TEXT_TYPE")) {
                this.display_type = 0;
            }
            if (string3.equalsIgnoreCase("LED_TYPE")) {
                this.display_type = 1;
            }
            if (string3.equalsIgnoreCase("BAR_TYPE")) {
                this.display_type = 2;
            }
            if (string3.equalsIgnoreCase("TREND_TYPE")) {
                this.display_type = 3;
            }
        }
    }

    public void addTag(String string) {
        this.IsStatement = false;
        if (string.startsWith("(")) {
            this.IsStatement = true;
        }
        this.Tagname = string;
        if (!this.IsStatement) {
            if (!this.ta.tagExist(string)) {
                this.ta.addTag(string);
            }
        } else {
            this.ip = new dgslStatement(2, string, this.ta);
            this.Tags = this.ip.getTagNames();
        }
        this.Tadapter.subscribeTagList(this, this.getTagNames());
    }

    public void addTag(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (string != null) {
                this.addTag(string);
                return;
            }
            ++n;
        }
    }

    public void addTag(TagsView tagsView) {
        this.addTag(tagsView.getTagNames());
    }

    public void removeTag(String string) {
        this.IsStatement = false;
        if (this.Tagname.equals(string)) {
            this.Tagname = "";
        }
        this.Tadapter.subscribeTagList(this, this.getTagNames());
    }

    public void removeTag(Vector vector) {
        if (vector != null && vector.contains(this.Tagname)) {
            this.removeTag(this.Tagname);
        }
    }

    public void removeTag(TagsView tagsView) {
        this.removeTag(tagsView.getTagNames());
    }

    public Dimension getPreferredSize() {
        return new Dimension(90, 90);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        this.x_w_begin = 0;
        this.y_w_begin = 0;
        this.w_width = rectangle.width - 1;
        this.w_height = rectangle.height - 1;
        if (!this.ta.tagExist(this.Tagname)) {
            return;
        }
        Tag tag = this.ta.getTag(this.Tagname);
        if (this.IsStatement) {
            this.paint_text(graphics);
            return;
        }
        if (tag.getType() == 1) {
            this.paint_text(graphics);
        } else {
            double d = tag.doubleValue();
            double[] dArray = tag.getLimits();
            double d2 = dArray[2];
            double d3 = dArray[3];
            switch (this.display_type) {
                case 0: {
                    this.paint_text(graphics);
                    break;
                }
                case 1: {
                    this.paint_led(graphics);
                    break;
                }
                case 2: {
                    this.paint_bar(graphics);
                    break;
                }
                case 3: {
                    this.paint_trend(graphics);
                }
            }
            if (tag.isValid() && (d < d2 || d > d3)) {
                this.fireAlarmEvent("tag " + this.Tagname + " is outside limits", "", new Date().getTime());
            }
        }
        if (tag.getAcquisitionError()) {
            this.paint_load_error(graphics);
        }
    }

    void setNextType() {
        ++this.display_type;
        if (this.display_type == 4) {
            this.display_type = 0;
        }
        this.repaint();
    }

    double get_double_value() {
        if (!this.IsStatement) {
            if (!this.ta.tagExist(this.Tagname)) {
                return -1.0;
            }
            Tag tag = this.ta.getTag(this.Tagname);
            return tag.doubleValue();
        }
        if (this.ip != null && this.ip.get_load_value()) {
            return this.ip.getDoubleValue();
        }
        return 0.0;
    }

    String get_current_value() {
        if (!this.IsStatement) {
            if (!this.ta.tagExist(this.Tagname)) {
                return "";
            }
            Tag tag = this.ta.getTag(this.Tagname);
            return tag.stringValue();
        }
        if (this.ip != null) {
            return this.ip.getStringValue();
        }
        return "";
    }

    void paint_text(Graphics graphics) {
        Color color = graphics.getColor();
        double d = this.get_double_value();
        String string = this.get_current_value();
        String string2 = MyUtils.cut_precision(string, 3);
        graphics.setFont(this.textFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string2);
        if (n > this.w_width) {
            graphics.setFont(this.legendFont);
            fontMetrics = graphics.getFontMetrics();
            n = fontMetrics.stringWidth(string2);
        }
        int n2 = fontMetrics.getHeight();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(this.x_w_begin, this.y_w_begin, this.w_width, this.w_height);
        graphics.draw3DRect(this.x_w_begin, this.y_w_begin, this.w_width, this.w_height, true);
        graphics.fill3DRect(this.x_w_begin + (this.w_width - n) / 2 - 2, this.y_w_begin + (this.w_height - n2) / 2 - 2, n + 4, n2 + 4, false);
        if (this.IsStatement) {
            graphics.setColor(Color.cyan);
            graphics.drawString(string2, this.x_w_begin + (this.w_width - n) / 2, this.y_w_begin + (this.w_height + n2) / 2);
        } else {
            if (!this.ta.tagExist(this.Tagname)) {
                return;
            }
            Tag tag = this.ta.getTag(this.Tagname);
            if (tag.getType() == 1) {
                graphics.setColor(Color.cyan);
                graphics.drawString(string, this.x_w_begin + (this.w_width - n) / 2, this.y_w_begin + (this.w_height + n2) / 2);
            } else {
                double[] dArray = tag.getLimits();
                double d2 = dArray[2];
                double d3 = dArray[3];
                if (d < d2 || d > d3) {
                    graphics.setColor(Color.red);
                } else {
                    graphics.setColor(Color.green);
                }
                if (tag.isValid()) {
                    graphics.drawString(string2, this.x_w_begin + (this.w_width - n) / 2, this.y_w_begin + (this.w_height + n2) / 2);
                }
            }
        }
        graphics.setFont(this.legendFont);
        fontMetrics = graphics.getFontMetrics();
        n2 = fontMetrics.getHeight();
        graphics.setColor(Color.black);
        graphics.drawString(this.Tagname, this.x_w_begin + 2, this.y_w_begin + 2 + n2);
        graphics.setColor(color);
    }

    void paint_led(Graphics graphics) {
        if (!this.ta.tagExist(this.Tagname)) {
            return;
        }
        Tag tag = this.ta.getTag(this.Tagname);
        double[] dArray = tag.getLimits();
        double d = dArray[2];
        double d2 = dArray[3];
        double d3 = tag.doubleValue();
        Color color = graphics.getColor();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(this.x_w_begin, this.y_w_begin, this.w_width, this.w_height);
        graphics.draw3DRect(this.x_w_begin, this.y_w_begin, this.w_width, this.w_height, true);
        graphics.setColor(Color.white);
        graphics.fillOval(this.x_w_begin + (this.w_width - 20) / 2 - 2, this.y_w_begin + (this.w_height - 20) / 2 - 2, 22, 22);
        graphics.setColor(Color.darkGray);
        graphics.fillOval(this.x_w_begin + (this.w_width - 20) / 2, this.y_w_begin + (this.w_height - 20) / 2, 22, 22);
        if (tag.isValid()) {
            if (d3 < d || d3 > d2) {
                graphics.setColor(Color.red);
            } else {
                graphics.setColor(Color.green);
            }
            graphics.fillOval(this.x_w_begin + (this.w_width - 20) / 2, this.y_w_begin + (this.w_height - 20) / 2, 20, 20);
        }
        graphics.setColor(Color.white);
        graphics.fillOval(this.x_w_begin + (this.w_width - 20) / 2 + 4, this.y_w_begin + (this.w_height - 20) / 2 + 4, 4, 4);
        graphics.setFont(this.legendFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        graphics.setColor(Color.black);
        graphics.drawString(this.Tagname, this.x_w_begin + 2, this.y_w_begin + 2 + n);
        graphics.setColor(color);
    }

    void paint_bar(Graphics graphics) {
        int n = this.w_height - 30;
        if (!this.ta.tagExist(this.Tagname)) {
            return;
        }
        Tag tag = this.ta.getTag(this.Tagname);
        double[] dArray = tag.getLimits();
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = tag.doubleValue();
        String string = tag.stringValue();
        Color color = graphics.getColor();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(this.x_w_begin, this.y_w_begin, this.w_width, this.w_height);
        graphics.draw3DRect(this.x_w_begin, this.y_w_begin, this.w_width, this.w_height, true);
        graphics.setColor(Color.black);
        graphics.drawRect(this.x_w_begin + (this.w_width - 20) / 2 - 1, this.y_w_begin + (this.w_height - n) / 2 - 1, 21, n + 1);
        graphics.setFont(this.legendFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        int n3 = this.x_w_begin + (this.w_width + 20) / 2;
        int n4 = n3 + 5;
        int n5 = this.y_w_begin + (this.w_height + n) / 2;
        graphics.drawLine(n3, n5, n4, n5);
        graphics.drawString(String.valueOf(d), n4 + 1, n5);
        n5 = this.y_w_begin + (this.w_height - n) / 2 - 1;
        graphics.drawLine(n3, n5, n4, n5);
        graphics.drawString(String.valueOf(d2), n4 + 1, n5);
        n5 = this.y_w_begin + this.w_height / 2;
        graphics.drawString("V: " + MyUtils.cut_precision(string, 3), n4 + 1, n5);
        if (tag.isValid()) {
            int n6;
            if (d5 < d3 || d5 > d4) {
                graphics.setColor(Color.red);
            } else {
                graphics.setColor(Color.green);
            }
            if (d2 > d) {
                Double d6 = new Double(n);
                Double d7 = new Double((d5 - d) * d6 / (d2 - d));
                n6 = d7.intValue();
            } else {
                n6 = 0;
            }
            if (n6 > n) {
                n6 = n;
            }
            graphics.fillRect(this.x_w_begin + (this.w_width - 20) / 2, this.y_w_begin + (this.w_height + n) / 2 - n6, 20, n6);
        }
        graphics.setColor(Color.black);
        graphics.drawString(this.Tagname, this.x_w_begin + 2, this.y_w_begin + 2 + n2);
        graphics.setColor(color);
    }

    void paint_trend(Graphics graphics) {
        Color color = graphics.getColor();
        if (!this.ta.tagExist(this.Tagname)) {
            return;
        }
        Tag tag = this.ta.getTag(this.Tagname);
        double[] dArray = tag.getLimits();
        double d = dArray[0];
        double d2 = dArray[1];
        graphics.setColor(Color.lightGray);
        graphics.fillRect(this.x_w_begin, this.y_w_begin, this.w_width, this.w_height);
        graphics.draw3DRect(this.x_w_begin, this.y_w_begin, this.w_width, this.w_height, true);
        tagHistory tagHistory2 = tag.getTagHistory();
        if (tagHistory2 != null) {
            int n = tagHistory2.getHistoryDepth();
            boolean[] blArray = tagHistory2.getValidities();
            double[] dArray2 = tagHistory2.getDoubleValues();
            int n2 = this.x_w_begin + this.x_margin;
            int n3 = this.y_w_begin + this.y_margin;
            int n4 = this.w_width - 2 * this.x_margin;
            int n5 = this.w_height - 2 * this.y_margin;
            double d3 = d;
            double d4 = d2;
            int n6 = n2;
            int n7 = n3 + n5;
            graphics.setColor(Color.white);
            graphics.fillRect(n2, n3, n4, n5);
            graphics.setColor(Color.black);
            int n8 = 0;
            while (n8 < n) {
                double d5 = d4 - d3;
                if (d5 == 0.0) {
                    d5 = 1.0;
                }
                if (blArray[n8]) {
                    int n9;
                    Double d6 = new Double(n5);
                    Double d7 = new Double((dArray2[n8] - d3) * d6 / d5);
                    int n10 = n3 + n5 - d7.intValue();
                    if (n10 < n3) {
                        n10 = n3;
                    }
                    if (n10 > n3 + n5) {
                        n10 = n3 + n5;
                    }
                    if (n8 == 0) {
                        n9 = n2;
                        graphics.drawRect(n9, n10, 1, 1);
                        n6 = n9;
                        n7 = n10;
                    } else {
                        n9 = n2 + (n8 + 1) * n4 / 100;
                        if (blArray[n8 - 1]) {
                            graphics.drawLine(n6, n7, n9, n10);
                        } else {
                            graphics.drawRect(n9, n10, 1, 1);
                        }
                        n6 = n9;
                        n7 = n10;
                    }
                }
                ++n8;
            }
        }
        graphics.setFont(this.legendFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        graphics.setColor(Color.black);
        graphics.drawString(this.Tagname, this.x_w_begin + 2, this.y_w_begin + 2 + n);
        graphics.setColor(color);
    }

    void paint_load_error(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(Color.red);
        graphics.fillRect(this.x_w_begin + this.w_width - 4, this.y_w_begin, 4, 4);
        graphics.setColor(color);
    }

    void paint_bar_only(Graphics graphics, int n, int n2, int n3, int n4, double d, double d2, Color color) {
        double d3 = new Double(n4);
        if (!this.ta.tagExist(this.Tagname)) {
            return;
        }
        Tag tag = this.ta.getTag(this.Tagname);
        double d4 = tag.doubleValue();
        graphics.setColor(color);
        if (tag.isValid()) {
            double d5 = (d4 - d) * d3 / (d2 - d);
            if (d5 > d3) {
                d5 = d3;
            }
            if (d5 < 0.0) {
                d5 = 0.0;
            }
            int n5 = new Double(d5).intValue();
            if (d2 * d < 0.0) {
                double d6 = d4 * d3 / (d2 - d);
                int n6 = new Double(d6).intValue();
                if (n6 >= 0) {
                    if (tag.getAcquisitionError()) {
                        graphics.drawRect(n, n2 + n4 - n5, n3, n6);
                        return;
                    }
                    graphics.fillRect(n, n2 + n4 - n5, n3, n6);
                    return;
                }
                int n7 = new Double((0.0 - d) * d3 / (d2 - d)).intValue();
                if (tag.getAcquisitionError()) {
                    graphics.drawRect(n, n2 + n4 - n7, n3, -n6);
                    return;
                }
                graphics.fillRect(n, n2 + n4 - n7, n3, -n6);
                return;
            }
            if (d2 <= 0.0) {
                double d7 = d4 * d3 / (d2 - d);
                int n8 = new Double(d7).intValue();
                if (tag.getAcquisitionError()) {
                    graphics.drawRect(n, n2, n3, -n8);
                    return;
                }
                graphics.fillRect(n, n2, n3, -n8);
                return;
            }
            if (tag.getAcquisitionError()) {
                graphics.drawRect(n, n2 + n4 - n5, n3, n5);
                return;
            }
            graphics.fillRect(n, n2 + n4 - n5, n3, n5);
        }
    }

    class SymMouse
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == Tagdisplay.this) {
                Tagdisplay.this.Tagdisplay_MouseClick(mouseEvent);
            }
        }

        SymMouse() {
            Tagdisplay.this = Tagdisplay.this;
        }
    }
}

