/**
 * PRePTagEXEC: Defines EXEC - it writes a batch file and a text file, calls the batchfile with 
 *              the text file as arguments. If the batch file returns with an errorcode which 
 *		is less or equal than zero, the program successed and it will follow the 
 *		instructions of the third argument. Else the fourth argument will be followed.
 *
 *@author nh
 *@version 1.0
 *@see PRePMain, TagList, PRePTag
 */
package com.delec.prep;
import com.delec.prettylog.*;
import java.io.*;
import java.util.*;

public class PRePTagEXEC_old extends PRePTagCode
{
	/**
	 * value of the tag
	 */
	String value;

	/**
	 * Constructor
	 */
	public PRePTagEXEC_old()
	{
		super("EXEC_old");
	}

	/**
	 * create a new file
	 */
	public File fileMaker(Session session, String strPrefix, String strSuffix, String strPath)
	{
		try
		{
		    File file;
		    System.out.println("strPath:"+strPath+".");
		    if (strPath.equals(""))
		    {		    
			System.out.println("no path");
			file = File.createTempFile(strPrefix, strSuffix);
		    }
		    else
		    {
                        file = File.createTempFile(strPrefix, strSuffix, new File(strPath));
		    }
			file.deleteOnExit(); //after JVM no longer needed
			return file;
		}
		catch ( IOException e )
		{
			session.getExceptionList().addElement(new PRePException(this, e));
		}
		return null;
	}

	/**
	 * write a text in a specified file
	 */
	public void writeTextToFile(PRePTag prepTag, Session session, File file)
	{
		try
		{
			prepTag = session.getTagList().find(prepTag.getValue());
			FileWriter fileWriter = new FileWriter(file);
			PrintWriter printWriter = new PrintWriter(fileWriter);
			//PrintWriter pwOld = session.getPrintWriter();
			//session.setPrintWriter(printWriter);
			prepTag.compile(session, printWriter);
//session.setPrintWriter(pwOld);
//printWriter.print(prepTag.getAllValue());
			printWriter.close();
			fileWriter.close();
			printWriter = null;
			fileWriter = null;
		}
		catch ( Exception e )
		{
			session.getExceptionList().addElement(new PRePException(this, e));
		}
	}

	/**
	 * @param PrintWriter writer to compile the tag to
	 * @param TagList where the tags are stored
	 */
	public void compile(Session session)
	{
	    TagList tagList = session.getTagList();

	    int iArgs = getArgCount(tagList);

	    if (iArgs >= 4)
		{	    
		String strPath = "";

		if (iArgs == 5)
		    {
		    strPath = getArg(tagList, iArgs).getAllValue();
		}

		PRePTag tagNewValue = session.getTagList().find("ARG1");
		String strNewValue = "";

		if ( tagNewValue != null )
		    {
		    PRePTagCount tagCount = (PRePTagCount) tagList.find("ARG0");
		    int iCount = tagCount.getIntValue();

		    if ( tagCount.getIntValue() == 4 )
			{
			PRePTag tagSecond = tagList.find("ARG2");
			try
			    {
			    File fileBatch = fileMaker(session, "batch", ".bat", strPath);
			    File fileText = fileMaker(session, "text", ".txt", strPath);

			    writeTextToFile(tagNewValue, session, fileBatch);
			    writeTextToFile(tagSecond, session, fileText);

			    String strInstruction = fileBatch.getName();
			    int iErrorcode = 0;

			    String strTxt = "";

			    Process process = null;

			    try
				{
				Runtime runtime = Runtime.getRuntime();
				process = runtime.exec(strInstruction+" "+fileText.getName());
				{
				    // get input stream
				    BufferedReader br = new BufferedReader(new
									   InputStreamReader(process.getInputStream()));

				    String strLine = br.readLine();
						
				    while (strLine != null)
					{
					strLine = br.readLine();						  
					strTxt = strTxt + strLine;
				    }
				}
	
				iErrorcode = process.waitFor();
				int iExit = process.exitValue();					    
			    }
			    catch(Exception e)
			    {
				session.getExceptionList().addElement(new PRePException(this, e));
			    }
			    iErrorcode = process.waitFor();
			    PRePTagText pttOutputText = new PRePTagText("EXEC_MESSAGE", strTxt);
			    session.getTagList().addElement(pttOutputText);

			    if ( iErrorcode > 0 )
				{
				tagNewValue = session.getTagList().find("ARG4");
				strNewValue = tagNewValue.getValue();
			    }
			    else
				{
				tagNewValue = session.getTagList().find("ARG3");
						strNewValue = tagNewValue.getValue();
			    }

			    session.getPrintWriter().print(strNewValue);
			    session.getPrintWriter().flush();
			    tagList.outTag();
			}
			catch ( Exception e )
			{
			    session.getExceptionList().addElement(new PRePException(this, e));
			}
		    }
		}
		session.getExceptionList().addElement(new PRePException(this, "There was an argument missing!"));
	    }
	}


            public static void main(String strArgs[])
	{
	    try
	    {	    
	       // SecurityManager sm = System.getSecurityManager();


		if (strArgs.length == 2)
		    {
		    File fileBatch = new File(strArgs[0]);
		    File fileText = new File(strArgs[1]);

		    //sm.checkRead(fileBatch.getName());
		    //sm.checkRead(fileText.getName());

		    System.out.println("text file: "+fileText.getName());
		   // sm.checkDelete(fileText.getName());
		    System.out.println("batch file: "+fileBatch.getName());
		    //sm.checkDelete(fileBatch.getName());

		    String strInstruction = fileBatch.getName();
		    Runtime runtime = Runtime.getRuntime();
		    runtime.traceInstructions(true);
		    System.out.println(strInstruction+" "+fileText.getName());
		    Process process = runtime.exec(strInstruction+" "+fileText.getName());
System.out.println("runtime exec...");
		    try
		    {		    
			BufferedReader br = new BufferedReader(new
							       InputStreamReader(process.getInputStream()));

			String strTxt = "";
			String strLine = br.readLine();
						
			while (strLine != null)
			    {
			    strLine = br.readLine();						  
			    strTxt = strTxt + strLine;
			}
			System.out.println("txt: "+strTxt);
		    }
		    catch (Exception e)
		    {
			System.out.println("exception occurred: "+e);
		    }

		    int iErrorcode = process.waitFor();

		    System.out.println("Errorcode: "+iErrorcode);		    
		}
	    }
	    catch ( Exception e )
	    {
System.out.println("Exception occurred: "+e);
	    }
	}

}
