/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Pointer;
import com.jniwrapper.util.JAWT;
import com.jniwrapper.util.JAWT_DrawingSurface;
import com.jniwrapper.util.JAWT_DrawingSurfaceInfo;
import sun.awt.windows.WToolkit;

import javax.swing.*;
import java.awt.*;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * This class contains utility functions for accessing native windowing system data.
 * Functions use JAWT or internal implementation (sun.*) classes as appropriate.
 *
 * @author AKireyev
 */
public class WindowTools
{
    /**
     * Returns a native window handle of a given component.
     */
    public static int getWindowHandle(final Component component)
    {
        final int result[] = new int[1];
        Runnable runnable = new Runnable()
        {
            public void run()
            {
                if (JAWT.JDK_1_4)
                {
                    JAWT_DrawingSurface ds = JAWT.getDrawingSurface(component);
                    if ((ds.lock() & 1) != 0)
                    { // lock error - return null handle
                        result[0] = 0;
                    }
                    else
                    {
                        Win32DSI win32DSI = new Win32DSI();
                        JAWT_DrawingSurfaceInfo dsi = new JAWT_DrawingSurfaceInfo(win32DSI);
                        Pointer pDsi = new Pointer(dsi);
                        ds.getDrawingSurfaceInfo(pDsi);
                        result[0] = (int)win32DSI.getHandle().getValue();
                        ds.freeDrawingSurfaceInfo(pDsi);
                        ds.unlock();
                        JAWT.freeDrawingSurface(ds);
                    }
                }
                else
                {
                    try
                    {
                        Method method = WToolkit.class.getMethod("getNativeWindowHandleFromComponent", new Class[]{Component.class});
                        result[0] = ((Integer)method.invoke(WToolkit.getWToolkit(), new Object[]{component})).intValue();
                    }
                    catch (Exception e)
                    {
                        throw new RuntimeException(e.toString());
                    }
                }
            }
        };
        runInDispatchThread(runnable);
        return result[0];
    }

    private static void runInDispatchThread(Runnable runnable)
    {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try
            {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e)
            {
                e.printStackTrace();
            }
            catch (InvocationTargetException e)
            {
                if (e.getTargetException() instanceof RuntimeException)
                {
                    RuntimeException runtimeException = (RuntimeException)e.getTargetException();
                    throw runtimeException;
                } else {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * Retrurns an AWT component that corresponds to a given native handle.
     */
    public static Component getComponentFromHandle(final int handle)
    {
        final Component[] result = new Component[1];
        Runnable runnable = new Runnable()
        {
            public void run()
            {
                if (JAWT.JDK_1_4)
                {
                    result[0] = JAWT.getComponentFromHandle(new Pointer.Void(handle));
                }
                else
                {
                    try
                    {
                        Method method = WToolkit.class.getMethod("getComponentFromNativeWindowHandle", new Class[]{Component.class});
                        result[0] = (Component)method.invoke(WToolkit.getWToolkit(), new Object[]{new Integer(handle)});
                    }
                    catch (Exception e)
                    {
                        throw new RuntimeException(e.toString());
                    }
                }
            }
        };
        runInDispatchThread(runnable);
        return result[0];
    }
}
