/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.DataBuffer;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.ZeroTerminatedString;

public class AnsiString
extends ZeroTerminatedString {
    private static final int CHAR_LENGTH = PlatformContext.getCharLength();

    public AnsiString() {
        this(256);
    }

    public AnsiString(int n2) {
        this("", n2);
    }

    public AnsiString(String string) {
        this(AnsiString.ansiStringToBytes(string));
    }

    public AnsiString(String string, int n2) {
        this(AnsiString.ansiStringToBytes(string), n2 * CHAR_LENGTH);
    }

    private AnsiString(byte[] byArray) {
        this(byArray, byArray.length + CHAR_LENGTH);
    }

    private AnsiString(byte[] byArray, int n2) {
        super(byArray, n2, CHAR_LENGTH);
    }

    public AnsiString(AnsiString ansiString) {
        this(ansiString.getValue(), ansiString.getMaxLength());
    }

    protected String bytesToString(byte[] byArray) {
        int n2 = 0;
        while (n2 < this.getMaxLength()) {
            if (byArray[n2] == 0) break;
            ++n2;
        }
        return new String(byArray, 0, n2);
    }

    protected byte[] stringToBytes(String string) {
        byte[] byArray = AnsiString.ansiStringToBytes(string);
        return byArray;
    }

    private static byte[] ansiStringToBytes(String string) {
        return string.length() == 0 ? new byte[]{} : string.getBytes();
    }

    public Object clone() {
        return new AnsiString(this);
    }

    protected int getStrLen(DataBuffer dataBuffer, int n2) {
        int n3 = n2;
        while (n3 < n2 + this.getLength()) {
            byte by = dataBuffer.readByte(n3);
            if (by == 0) {
                return n3 - n2;
            }
            ++n3;
        }
        return this.getLength();
    }
}

