/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Callback;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.ui.User32;
import com.jniwrapper.win32.ui.WindowMessage;
import com.jniwrapper.win32.ui.WindowMessageListener;
import com.jniwrapper.win32.ui.Wnd;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class WindowProc
extends Callback {
    private static final FunctionName FUNCTION_DEF_WINDOW_PROC = new FunctionName("DefWindowProc");
    protected Wnd _wnd = new Wnd();
    protected UInt _msg = new UInt();
    protected UInt32 _wParam = new UInt32();
    protected UInt32 _lParam = new UInt32();
    protected UInt32 _lResult = new UInt32();
    private Function _defWindowProc;
    private boolean _substituted = false;
    private Handle _wndProc;
    private List _messageListeners = new LinkedList();

    public WindowProc(Wnd wnd) {
        this();
        this.setWnd(wnd);
    }

    public WindowProc() {
        this.init(new Parameter[]{this._wnd, this._msg, this._wParam, this._lParam}, (Parameter)this._lResult);
        this._defWindowProc = WindowProc.getDefWindowProc();
    }

    public void callback() {
        if (this.isSubstituted()) {
            this.notifyListeners(true);
            this._lResult.setValue(Wnd.callWindowProc(this._wndProc, this._wnd, this._msg, this._wParam, this._lParam));
            this.notifyListeners(false);
        } else {
            this._defWindowProc.invoke((Parameter)this._lResult, (Parameter)this._wnd, (Parameter)this._msg, (Parameter)this._wParam, (Parameter)this._lParam);
        }
    }

    private void notifyListeners(boolean beforeWndProc) {
        WindowMessage message = new WindowMessage((Object)this, (int)this._msg.getValue(), (int)this._wParam.getValue(), (int)this._lParam.getValue());
        Iterator i = this._messageListeners.iterator();
        while (i.hasNext()) {
            WindowMessageListener listener = (WindowMessageListener)i.next();
            if (!listener.canHandle(message, beforeWndProc)) continue;
            this._lResult.setValue((long)listener.handle(message));
            this._msg.setValue((long)message.getMsg());
            this._wParam.setValue((long)message.getWParam());
            this._lParam.setValue((long)message.getLParam());
        }
    }

    private static Function getDefWindowProc() {
        Function function = User32.getInstance().getFunction(FUNCTION_DEF_WINDOW_PROC.toString());
        return function;
    }

    public void addMessageListener(WindowMessageListener listener) {
        if (!this._messageListeners.contains(listener)) {
            this._messageListeners.add(listener);
        }
    }

    public void removeMessageListener(WindowMessageListener listener) {
        this._messageListeners.remove(listener);
    }

    public void substitute() {
        this._wndProc = new Handle(this._wnd.getWindowLong(-4));
        this._wnd.setWindowLong(-4, (Parameter)this);
        this._substituted = true;
    }

    public void restoreNative() {
        if (this._wndProc == null || this._wndProc.isNull()) {
            throw new IllegalStateException();
        }
        this._wnd.setWindowLong(-4, (Parameter)this._wndProc);
        this._substituted = false;
    }

    public boolean isSubstituted() {
        return this._substituted;
    }

    public Wnd getWnd() {
        return this._wnd;
    }

    public void setWnd(Wnd wnd) {
        if (wnd == null || wnd.isNull()) {
            throw new IllegalArgumentException();
        }
        boolean wasSubstituted = this.isSubstituted();
        if (wasSubstituted) {
            this.restoreNative();
        }
        this._wnd.setValue(wnd.getValue());
        if (wasSubstituted) {
            this.substitute();
        }
    }
}

