/*
 * Decompiled with CFR 0.152.
 */
package jdbees.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import jdbees.JBeesConfInfo;
import jdbees.JBeesResumeFileInfo;
import jdbees.JBeesTeam;
import jdbees.http.JBeesHttpBee;
import jdbees.http.JBeesHttpRemoteInfo;
import jdbees.http.TooManyRedirectionException;

public class JBeesHttpTeam
extends JBeesTeam {
    private boolean debug = false;
    private URL redURL;
    private int respCode;
    private String reason;
    private boolean supChunked;
    private boolean supRange;
    private boolean success;
    private JBeesHttpBee[] jbhb;
    private String user = null;
    private String passwd = null;

    public JBeesHttpTeam(URL url, String localFileName, JBeesConfInfo conf) throws IOException {
        super(url, localFileName, conf);
        this.user = conf.getHttpAuthUser();
        this.passwd = conf.getHttpAuthPasswd();
        this.redURL = url;
    }

    public JBeesHttpTeam(URL url, String localFileName, JBeesConfInfo conf, String user, String passwd) throws IOException {
        super(url, localFileName, conf);
        this.redURL = url;
        this.user = user;
        this.passwd = passwd;
        this.jbrfi.setUser(user);
        this.jbrfi.setPasswd(passwd);
    }

    public JBeesHttpTeam(JBeesResumeFileInfo resume, JBeesConfInfo conf) throws IOException, MalformedURLException {
        super(resume, conf);
        this.redURL = new URL(resume.getOrgURL());
        if (resume.getUser() != null) {
            this.user = resume.getUser();
            this.passwd = resume.getPasswd();
        } else {
            this.user = conf.getHttpAuthUser();
            this.passwd = conf.getHttpAuthPasswd();
        }
    }

    public void setInterrupted() {
        if (this.jbhb == null) {
            return;
        }
        int i = 0;
        while (i < this.jbhb.length) {
            if (this.jbhb[i] != null) {
                this.jbhb[i].setInterrupted(true);
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    public void JBeesFlying() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void startRecv() throws IOException {
        if (this.jbrfi.getRemoteBegin() != null) {
            this.doResuming();
        } else if (this.fileLen > 0L) {
            if (this.supRange) {
                this.doMultiple();
            } else {
                this.doSingle();
            }
        } else if (this.supChunked) {
            this.doChunked();
        }
    }

    private void doResuming() throws IOException {
        int segment = this.jbrfi.getRemoteBegin().length;
        if (this.supRange) {
            this.jbts.setSupportMultiThread(true);
            this.jbhb = new JBeesHttpBee[segment];
            int i = 0;
            while (i < segment) {
                long begin = this.jbrfi.getRemoteBegin(i);
                long end = this.jbrfi.getRemoteEnd(i);
                long len = end - begin + 1L;
                if (len > 0L) {
                    this.jbhb[i] = new JBeesHttpBee(this.redURL, this.jblf, begin, end, false, this, i, this.jbcfi, this.user, this.passwd);
                    Thread t = new Thread(this.tg, this.jbhb[i]);
                    t.start();
                } else {
                    this.jbhb[i] = null;
                }
                ++i;
            }
        } else if (this.supChunked) {
            this.doChunked();
        } else {
            this.doSingle();
        }
    }

    private void doMultiple() throws IOException {
        this.jbts.setSupportMultiThread(true);
        int segment = this.jbcfi.getJBeesNum();
        this.jbhb = new JBeesHttpBee[segment];
        Thread[] t = new Thread[segment];
        long step = this.fileLen / (long)segment;
        this.jbrfi.setSegment(segment);
        int i = 0;
        while (i < segment) {
            long begin = step * (long)i;
            if (i > 0) {
                ++begin;
            }
            long end = step * (long)(i + 1);
            if (i + 1 == segment) {
                end = this.fileLen - 1L;
            }
            this.jbrfi.setRemoteBegin(i, begin);
            this.jbrfi.setRemoteEnd(i, end);
            this.jbhb[i] = new JBeesHttpBee(this.redURL, this.jblf, begin, end, false, this, i, this.jbcfi, this.user, this.passwd);
            t[i] = new Thread(this.tg, this.jbhb[i]);
            t[i].start();
            if (this.debug) {
                System.out.println("Thread[" + i + "] from " + begin + " to " + end);
            }
            ++i;
        }
    }

    private void doChunked() throws IOException {
        this.doAlone(true, 0L);
    }

    private void doAlone(boolean isChunked, long end) throws IOException {
        this.setPercent(0.0);
        this.jbts.setSupportMultiThread(false);
        this.jbrfi.setSegment(1);
        this.jbrfi.setRemoteBegin(0, 0L);
        this.jbrfi.setRemoteEnd(0, end);
        this.jbhb = new JBeesHttpBee[1];
        this.jbhb[0] = new JBeesHttpBee(this.redURL, this.jblf, 0L, end, isChunked, this, 0, this.jbcfi, this.user, this.passwd);
        Thread t = new Thread(this.tg, this.jbhb[0]);
        t.start();
        if (this.debug) {
            System.out.println("transfer in " + (!isChunked ? "Single thread mode" : "chunked mode"));
        }
    }

    private void doSingle() throws IOException {
        this.doAlone(false, this.fileLen - 1L);
    }

    private void getRemoteInfo() throws IOException, TooManyRedirectionException {
        JBeesHttpRemoteInfo jbhri = new JBeesHttpRemoteInfo(this.url, this.user, this.passwd, this.jbcfi);
        this.success = jbhri.isSuccess();
        if (this.success) {
            this.redURL = jbhri.getURL();
            this.fileLen = jbhri.getRemoteFileLength();
            this.jbts.setRemoteFileLength(this.fileLen);
            this.supRange = jbhri.isSupportRange();
            this.supChunked = jbhri.getChunked();
        } else {
            this.respCode = jbhri.getRespCode();
            this.reason = jbhri.getReason();
        }
    }
}

