/*
 * Decompiled with CFR 0.152.
 */
package jdbees;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;

public class JBeesNetworkIO {
    private Socket socket;

    public JBeesNetworkIO(URL url) throws IOException {
        this.getSocket(url);
    }

    public JBeesNetworkIO(String host, int port) throws IOException {
        this.getSocket(host, port);
    }

    private void getSocket(URL url) throws IOException {
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        if (port == -1) {
            port = protocol.equalsIgnoreCase("http") ? 80 : 21;
        }
        this.getSocket(host, port);
    }

    private void getSocket(String host, int port) throws IOException {
        this.socket = new Socket(host, port);
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = this.socket.getInputStream();
        return is;
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream os = this.socket.getOutputStream();
        return os;
    }

    public PrintWriter getPrintWriter() throws IOException {
        return new PrintWriter(this.getOutputStream());
    }

    public InputStreamReader getInputStreamReader() throws IOException {
        return new InputStreamReader(this.getInputStream());
    }

    public BufferedReader getBufferedReader() throws IOException {
        return new BufferedReader(this.getInputStreamReader());
    }

    public BufferedInputStream getBufferedInputStream() throws IOException {
        return new BufferedInputStream(this.getInputStream());
    }

    public DataInputStream getDataInputStream() throws IOException {
        return new DataInputStream(this.getInputStream());
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public void setTimeout(int seconds) throws SocketException {
        this.socket.setSoTimeout(seconds);
    }

    public int getLocalPort() throws IOException {
        return this.socket.getLocalPort();
    }

    public String getLocalIP() throws IOException {
        return this.socket.getLocalAddress().getHostAddress();
    }
}

