/****************************************************

	JConfig Source Code Distribution
	version: 2.1.0      written: Mon May 28 10:11:26 PDT 2001

	Unless otherwise noted, all contents
	Copyright (c) 1997,1998,1999,2000 Samizdat Productions.
	All Rights Reserved.
	All contents are subject to the terms of the
	JConfig Source Code License Agreement

****************************************************/

#ifndef INC_SAppFinder_H
#define	INC_SAppFinder_H

#include "comdefs.h"
#include "CString.h"
#include "CStringVector.h"
#include "AppData.h"

/*------------------------------------------------------------------------
CLASS
	SAppFinder

	Routines for finding applications.

DESCRIPTION
	Routines for finding applications.

------------------------------------------------------------------------*/

class SAppFinder
{
public:
	
		///////////////////////
		//
		//  Searches the Registry for entries which mention of an application, and returns the registry entries in
		//	'VAT' format.
		//	A 'VAT' consists of a set of four strings: an extension, a Registry key, a verb, and a command line.
		//	Ex. { ".txt", "txtfile\\shell\\open\\command", "open", "c:\windows\notepad %1" }
		//
		//  [in]	fullPath		The full path of the application.
		//  [in]	fileName		The name of the application.
		//  [out]	vatVec			On exit, contains the returned strings.
		//  [in]	maxToReturn		The full path of the application.
		//  [out]	numReturned		On exit, contains the number of entries
		//
	static	ErrCode iNativeFindVerbs( const CStr *fullPath, const CStr *fileName, CStringVector *vatVec,
									long maxToReturn, long *numReturned ); 
	
		///////////////////////
		//
		//	Finds apps by name.
		//
		//  [in]	appName			The application name.
		//	[in]	defaultDir		the default directory
		//  [in]	maxToReturn		The maximum number of apps to return
		//  [in]	flags			The lower 2 bits indicate the search level,
		//							with 0 being the fastest and 3 being the most extensive
		//  [out]	pRetTable		On exit, contains the found applications.
		//
	static	ErrCode iNativeFindAppsByName( const CStr *appName, const CStr *defaultDir, long maxToReturn,
											long flags, CStringVector *pRetTable );
	
		///////////////////////
		//
		//	Finds apps by extension.
		//
		//  [in]	fileExt			The extension.
		//	[in]	tempDir			The path to a writable temporary directory.
		//  [in]	maxToReturn		The maximum number of apps to return
		//  [in]	flags			Various flags
		//  [out]	pRetTable		On exit, contains the found applications.
		//
	static	ErrCode iNativeFindAppsByExtension( const CStr *fileExt, const CStr *tempDir, long maxToReturn,
												long flags, CStringVector *pRetTable );
	
protected:

	static	const CStr	*gcsRegKeyAppPath, *gcsExeExtension;

	static	ErrCode iNativeFindAppsByNameLevel0( const CStr *appName, const CStr *defaultDir, long maxToReturn,
													long flags, CStringVector *pRetTable );
	static	ErrCode iNativeFindAppsByNameLevel1( const CStr *appName, const CStr *defaultDir, long maxToReturn,
													long flags, CStringVector *pRetTable );
	static	ErrCode iNativeFindAppsByNameAppPaths( const CStr *appName, const CStr *defaultDir, long maxToReturn,
													long flags, CStringVector *pRetTable );
	static	ErrCode iNativeFindAppsByNameFindExe( const CStr *appName, const CStr *defaultDir, long maxToReturn,
													long flags, CStringVector *pRetTable );
	static	ErrCode	altFindExecutable( const CStr *fileExt, CStr *retExe );
};

#endif

