/****************************************************

	JConfig Source Code Distribution
	version: 2.1.0      written: Mon May 28 10:11:26 PDT 2001

	Unless otherwise noted, all contents
	Copyright (c) 1997,1998,1999,2000 Samizdat Productions.
	All Rights Reserved.
	All contents are subject to the terms of the
	JConfig Source Code License Agreement

****************************************************/

#include "CFSpec.h"
#include "CUtils.h"
#include "Debugger.h"

#if defined(DO_JNI)

CFSpec::CFSpec( JNIEnv *pEnv, long vr, long pi, JBYTEARRAY pSrc )
{
	unsigned char	*srcP;
	long			numToCopy, srcArrayLen;
	jboolean		dummy;

	theSpec.vRefNum = vr;
	theSpec.parID = pi;
	if ( pSrc == NULL ) {
		theSpec.name[ 0 ] = 0;
		return;
	}

	srcArrayLen = ( pEnv->GetArrayLength )( pSrc );
	srcP = (unsigned char*) ( pEnv->GetByteArrayElements )( pSrc, &dummy );

	numToCopy = srcP[ 0 ] + 1;
	if ( numToCopy > kSpecNameLen || numToCopy > srcArrayLen )
		throw _TXL( "CFS string too long" );

	BlockMoveData( srcP, &theSpec.name[ 0 ], numToCopy );

	( pEnv->ReleaseByteArrayElements )( pSrc, (jbyte*) srcP, 0 );
}

#elif defined(DO_JRI)

CFSpec::CFSpec( JRIEnv *pEnv, long vr, long pi, JBYTEARRAY pSrc )
{
	unsigned char	*srcP;
	long			numToCopy, srcArrayLen;

	theSpec.vRefNum = vr;
	theSpec.parID = pi;
	if ( pSrc == NULL ) {
		theSpec.name[ 0 ] = 0;
		return;
	}

	srcArrayLen = JRI_GetByteArrayLength( pEnv, pSrc );
	srcP = (unsigned char*) JRI_GetByteArrayElements( pEnv, pSrc );

	numToCopy = srcP[ 0 ] + 1;
	if ( numToCopy > kSpecNameLen || numToCopy > srcArrayLen )
		throw _TXL( "CFS string too long" );

	BlockMoveData( srcP, &theSpec.name[ 0 ], numToCopy );
}

#endif

CFSpec::CFSpec( long vr, long pi, StringPtr ps )
{
	theSpec.vRefNum = vr;
	theSpec.parID = pi;
	if ( ps == NULL )
		theSpec.name[ 0 ] = 0;
	else
		CUtils::pStrncpy( &( theSpec.name[ 0 ] ), ps, ( kSpecNameLen - 1 ) );
}

CFSpec::CFSpec( const CFSpec *cfs )
{
	BlockMoveData( &cfs->theSpec, &theSpec, sizeof(FSSpec) );
}

CFSpec::~CFSpec()
{
}

long CFSpec::getVRef() const
{
	return theSpec.vRefNum;
}

long CFSpec::getParID() const
{
	return theSpec.parID;
}

StringPtr CFSpec::getName()
{
	return &theSpec.name[ 0 ];
}

FSSpec *CFSpec::getSpecP()
{
	return &theSpec;
}

ErrCode CFSpec::verify()
{
	return FSMakeFSSpec( theSpec.vRefNum, theSpec.parID, &theSpec.name[ 0 ], &theSpec );
}

BOOL CFSpec::isNameNull() const
{
	return ( theSpec.name[ 0 ] == 0 );
}

void CFSpec::setFrom( const CFSpec *cfs )
{
	BlockMoveData( &cfs->theSpec, &theSpec, sizeof(FSSpec) );
}

void CFSpec::setFrom( long vr, long pi, StringPtr ps )
{
	theSpec.vRefNum = vr;
	theSpec.parID = pi;
	if ( ps == NULL )
		theSpec.name[ 0 ] = 0;
	else
		CUtils::pStrncpy( &( theSpec.name[ 0 ] ), ps, ( kSpecNameLen - 1 ) );
}

void CFSpec::putInto( FSSpec *toSpec ) const
{
	BlockMoveData( &theSpec, toSpec, sizeof(FSSpec) );
	if ( toSpec->name[ 0 ] > 63 )
		toSpec->name[ 0 ] = 63;
}

void CFSpec::dumpInfo( long theErr, const LPCTSTR message ) const
{
	CStr		*tempStr;
	char		tempBuf[ 256 ];
	
	CUtils::pStrToCString( tempBuf, &theSpec.name[ 0 ] );
	tempStr = new CStr( tempBuf );

	Debugger::debug( __LINE__, message, tempStr, NULL, theErr, theSpec.vRefNum, theSpec.parID );

	delete tempStr;
}

