package com.tolstoy.imagemeister;

import java.io.*;
import java.awt.Event;
import com.jconfig.Trace;

/**
Watches a file to which an external program, such as the shell app used to open IM, will occasionally
write commands, such as a command to show the about box.

When a command is read from this file, an event is created, and sent to the processEvent() method
of an object which implements the DDCommandRecipient interface.

@author Copyright (c) 1997,1998,1999,2000 Samizdat Productions. All Rights Reserved.
*/

class DDSource implements Runnable {
	DataInputStream		dis;
	DDCommandRecipient	recipient;

	public DDSource( String fileName, DDCommandRecipient recip )
	throws IOException {
		dis = null;
		recipient = null;

		if ( fileName == null )
			return;

		recipient = recip;

		dis = new DataInputStream( new FileInputStream( fileName ) );		
	}

	public void run() {
		String				ss;
		int					xxx = 0;

		if ( dis == null ) {
			Trace.println( "DDSource.run: dis is null" );
			return;
		}

		while ( true ) {
			try {
				Thread.currentThread().sleep( 100 );

				ss = dis.readLine();
			}
			catch ( Exception e ) {
				break;
			}
			if ( ss == null || ss.equals( "" ) )
				continue;

			Trace.println( "sending event " + ss );
			sendEvent( ss );
		}
	}

	public void sendEvent( String ss ) {
		Event		ev;
		int			eq, first, second;
		String		command, arg;

		eq = ss.indexOf( "=" );
		if ( eq == 0 )
			return;
		else if ( eq > 0 ) {
			command = ss.substring( 0, eq );
			arg = ss.substring( eq + 1, ss.length() );
			first = ss.indexOf( "\"" );
			if ( first >= 0 ) {
				second = ss.indexOf( "\"", first + 1 );
				if ( second >= 0 )
					arg = ss.substring( first + 1, second );
				else
					arg = ss.substring( first + 1, ss.length() );
			}
		}
		else {
			command = ss;
			arg = null;
		}

		Trace.println( "sendEvent: cmd=" + command + ", arg=" + arg );
		ev = createEvent( command, arg );

		if ( ev != null )
			recipient.processEvent( ev );
	}

	Event createEvent( String command, String arg ) {
		if ( command.equalsIgnoreCase( "open" ) )
			return new Event( this, DDCommandRecipient.kOpenDoc, arg );

		else if ( command.equalsIgnoreCase( "opencommand" ) )
			return new Event( this, DDCommandRecipient.kOpenCommand, arg );

		else if ( command.equalsIgnoreCase( "openurlcommand" ) )
			return new Event( this, DDCommandRecipient.kOpenURLCommand, arg );

		else if ( command.equalsIgnoreCase( "aboutcommand" ) )
			return new Event( this, DDCommandRecipient.kAboutCommand, arg );

		else
			return null;
	}
}

