/*Data Access Library. v. 1.1.
 *Manager event support.
 *AUTHOR:  Alexander Jaremenko <jarem@altavista.net>
 *RELEASE DATE: 
 */

package JProjects.eab.data;

/**Support for manager events. Used in <code>DAManager</code>.
 *@see ManagerCompleteListener
 *@see DAManager#addManagerCompleteListener
 *@see DAManager#removeManagerCompleteListener
 *@author Alexander Jaremenko  <address><a href="mailto:jarem@altavista.net">&lt jarem@altavista.net &gt</a></address>
*/
public class ManagerCompleteSupport extends ParameterSupport 
{

    public ManagerCompleteSupport(Object src) {
	super(src);
    }

    public void addManagerCompleteListener(ManagerCompleteListener l) {
	addParameterListener(l);
    }

    public void fireCancelComplete() {
	ManagerCompleteEvent ev = new ManagerCompleteEvent(_source,"cancel()");
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ManagerCompleteListener)
		((ManagerCompleteListener)_listeners[i]).cancelComplete(ev);
    }

    public void fireCloseComplete() {
	ManagerCompleteEvent ev = new ManagerCompleteEvent(_source,"close()");
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ManagerCompleteListener)
		((ManagerCompleteListener)_listeners[i]).closeComplete(ev);
    }

    public void fireDeleteFetchedComplete() {
	ManagerCompleteEvent ev = new ManagerCompleteEvent(_source,"deleteFetched()");
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ManagerCompleteListener)
		((ManagerCompleteListener)_listeners[i]).deleteFetchedComplete(ev);
    }

    public void fireFetchComplete(String acnN,Boolean res) {
	ManagerCompleteEvent ev = new ManagerCompleteEvent(_source,acnN,res);
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ManagerCompleteListener)
		((ManagerCompleteListener)_listeners[i]).fetchComplete(ev);
    }

    public void fireFillComplete(String acnN, Integer res) {
	ManagerCompleteEvent ev = new ManagerCompleteEvent(_source,acnN,res);
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ManagerCompleteListener)
		((ManagerCompleteListener)_listeners[i]).fillComplete(ev);
    }

    public void fireItemsModified() {
	ManagerCompleteEvent ev = new ManagerCompleteEvent(_source,"itemsModified()");
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ManagerCompleteListener)
		((ManagerCompleteListener)_listeners[i]).itemsModified(ev);
    }

    public void fireOpenComplete(String acnN) {
	ManagerCompleteEvent ev = new ManagerCompleteEvent(_source,acnN);
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ManagerCompleteListener)
		((ManagerCompleteListener)_listeners[i]).openComplete(ev);
    }

    public void fireOpenComplete(String acnN, Object res) {
	ManagerCompleteEvent ev = new ManagerCompleteEvent(_source,acnN,res);
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ManagerCompleteListener)
		((ManagerCompleteListener)_listeners[i]).openComplete(ev);
    }

    public void firePrepareOpenComplete(String acnN) {
	ManagerCompleteEvent ev = new ManagerCompleteEvent(_source,acnN);
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ManagerCompleteListener)
		((ManagerCompleteListener)_listeners[i]).prepareOpenComplete(ev);
    }

    public void fireSelectComplete(String acnN) {
	ManagerCompleteEvent ev = new ManagerCompleteEvent(_source,acnN);
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ManagerCompleteListener)
		((ManagerCompleteListener)_listeners[i]).selectComplete(ev);
    }

    public void fireSelectComplete(String acnN, Object res) {
	ManagerCompleteEvent ev = new ManagerCompleteEvent(_source,acnN,res);
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ManagerCompleteListener)
		((ManagerCompleteListener)_listeners[i]).selectComplete(ev);
    }

    public void fireUpdateFetchedComplete() {
	ManagerCompleteEvent ev = new ManagerCompleteEvent(_source,"updateFetched()");
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ManagerCompleteListener)
		((ManagerCompleteListener)_listeners[i]).updateFetchedComplete(ev);
    }

    public void removeManagerCompleteListener(ManagerCompleteListener l) {
	removeParameterListener(l);
    }

}
