/*Data Access Library. v. 1.1.
 *Informix datastore. 
 *AUTHOR:  Alexander Jaremenko <jarem@altavista.net>
 *RELEASE DATE: 
 */

package JProjects.eab.data;
import java.util.*;
import java.sql.*;

/**Implements support for some informix - specific features.
 *@author Alexander Jaremenko  <address><a href="mailto:jarem@altavista.net">&lt jarem@altavista.net &gt</a></address>
*/
public class InformixJDBC extends DatastoreJDBC {

    public InformixJDBC() {}

    public InformixJDBC(String url) {
	super(url);
    }

    public InformixJDBC(String url,Properties prop) {
	super(url,prop);
    }

    /**Gets last generated serial value after inserting row with Primary Key that consist
     *of 1 column of <code>serial</code> data type.
     *@param table - name of any existing table - just to generate valid SQL.
     *@return - last generated serial value.
     *@exception JProjects.eab.data.DAException - if data access error occur.
     */
    public int serialKey(String table) throws DAException {
	if (!isConnected())
	    throw new DAException(DAResource.NO_CONNECT_EXIST);
	int res = -1;
	try {
	    Statement stmt = getConnection().createStatement();
	    ResultSet rs = stmt.executeQuery("select unique dbinfo(\'sqlca.sqlerrd1\') from "+table);
	    if (rs.next())
		res = rs.getInt(1);
	    stmt.close();
	} catch(SQLException ex) {
	    throw new DAException(DAResource.ERROR_IN_METHOD,"serialKey(String)",ex);
	}
	return res;
    }
}
