//
//
//                                                           %__________%
//                                                          %/ . .  .   \%
//           Van Gogh 2D-Display Library                     |  . .  o. |
//                                                           |. _  .   .|
//        Microsoft Windows 95/98/NT Version                 | / \   .  |
//                                                           |_|_|_._._.|
//                                                           |.-.-.-.-..|
//                                                          %\__________/%
//                                                           %          %
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Tim Little
//
// vngvp.cpp
//
//

//
//
//                                Includes
//
//

#include <string.h>
#include <assert.h>
#include "debug.h"
#include "portable.h"
#include "ivory.h"
#include "vangogh.hpp"
#include "XFile.hpp"

//
//
//                                Equates
//
//

//
//
//                               Structures
//
//

//
//
//                               Routines
//
//

//
//
//                                 Data
//
//

//
//
//                                 Code
//
//


//Ŀ
//                                                                          
// This is the Base View Port stuff.                                        
//                                                                          
//
//Ŀ
// This function will capture a viewport to an XFBitmap.                    
//

VNGError VngoVport::capture(XFBitmap *bm)
{
// Copy data into bitmap
    if (vbuff.pal->flags & VNGO_8BIT)
    {
        if (bm->create(ushort(vbuff.width),ushort(vbuff.height),1))
            return VNGO_MEMALLOC_ERROR;

        memcpy (bm->pal, &vbuff.pal->hw_pal.p[0], 256 * sizeof (dword));

        byte *dptr = bm->data;
        byte *sptr = vbuff.scrn_ptr;
        for (int y = 0; y < vbuff.height; ++y)
        {
            memcpy (dptr, sptr, vbuff.width);
            dptr += vbuff.width;
            sptr += vbuff.pitch;
        }
    }
    else if (vbuff.pal->flags & VNGO_15BIT)
    {
        if (bm->create(ushort(vbuff.width),ushort(vbuff.height),3))
            return VNGO_MEMALLOC_ERROR;

        byte *dptr = bm->data;
        byte *sptr = vbuff.scrn_ptr;
        for (int y = 0; y < vbuff.height; ++y)
        {
            word *tptr = (word*)sptr;
            for(int x = 0; x < vbuff.width; ++x)
            {
                word pcolor = *(tptr++);

                *(dptr++) = (pcolor >> 7) & 0xf8;
                *(dptr++) = (pcolor >> 2) & 0xf8;
                *(dptr++) = (pcolor << 3) & 0xf8;
            }

            sptr += vbuff.pitch;
        }
    }
    else if (vbuff.pal->flags & VNGO_16BIT)
    {
        if (bm->create(ushort(vbuff.width),ushort(vbuff.height),3))
            return VNGO_MEMALLOC_ERROR;

        byte *dptr = bm->data;
        byte *sptr = vbuff.scrn_ptr;
        for (int y = 0; y < vbuff.height; ++y)
        {
            word *tptr = (word*)sptr;
            for(int x = 0; x < vbuff.width; ++x)
            {
                word pcolor = *(tptr++);

                *(dptr++) = (pcolor >> 8) & 0xf8;
                *(dptr++) = (pcolor >> 3) & 0xfc;
                *(dptr++) = (pcolor << 3) & 0xf8;
            }

            sptr += vbuff.pitch;
        }
    }
    return VNGO_NO_ERROR;
}

// End of module - vngvp.cpp 
