//
//                               Jb
//                               $$$c
//             $$$$$$$$$$$$$$$$$$$$$$b       d$$$$$$$$$$$$$$$$$$$$$P
//            .$$$$$$$$$$$$$$$$$$$$$$$$.     $$$$$$$$$$$$$$$$$$$$$$
//            ^""""""$$$$$P""""3$$$$$$$$c   d$$$$$""""$$$$$$"""""""
//                  4$$$$$"    $$$$$$$$$$b  $$$$$F   .$$$$$F
//                  $$$$$P    4$$$$$$$$$$$$$$$$$$    d$$$$$
//                 4$$$$$"    $$$$$$$$$$$$$$$$$$P    $$$$$F
//                 $$$$$$    4$$$$$""$$$$$$$$$$$    d$$$$$
//                4$$$$$"    $$$$$$  ^$$$$$$$$$P    $$$$$F
//                $$$$$$    4$$$$$%    *$$$$$$$"   J$$$$$
//               4$$$$$%    $$$$$$      ^$$$$$P    $$$$$F
//               """"""     """"""        *$$$"    """"""
//                                         "$$
//                                          ^%
//
//                         Turner - Networking Library
//
//                    Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1995-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
//                              ** Tester **
//
// Created by Dan Higdon and Chuck Walbourn
//
// turner.cpp
//
//

//
//
//                                Includes
//
//

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>

#include <ivory.hpp>

#include <windows.h>
#include <initguid.h>

#include "Turner.hpp"

//
//
//                               Structures
//
//

//
//
//                                Classes
//
//

class TurnerTest : public TurnerNetwork
{
public:
    TurnerTest(GUID guid, const char *_name, int _players) :
        TurnerNetwork(guid,_name,_players,TURNER_DPSESSION_FLAGS) {};

    virtual void handle_msg (DPID from, DPID to, LPVOID ptr, DWORD size);
    virtual void handle_chat (DPID fromplayer, DPID toplayer, DPID togroup, LPSTR msg);
};

//
//
//                               Routines
//
//

BOOL PumpWindows();
static BOOL InitApplication (HINSTANCE, int, int, int);
LRESULT CALLBACK ClientWndProc (HWND, UINT, WPARAM, LPARAM);

char *str_error(char *str, int err);

//
//
//                                 Data
//
//

// Global Windows data
HINSTANCE       hInst;
HWND            hWndClient;
const char      szAppName[]     = "Turner Tester";

// Tester data
TurnerNetwork   *Net    = 0;
TurnerNetworkUI *NetUI  = 0;

// {8639DD81-6913-11d2-99EF-00600868B817}
DEFINE_GUID(TEST_GUID,
0x8639dd81, 0x6913, 0x11d2, 0x99, 0xef, 0x0, 0x60, 0x8, 0x68, 0xb8, 0x17);

//
//
//                                 Code
//
//

//
// WinMain
//
int APIENTRY WinMain (HINSTANCE hInstance,
                      HINSTANCE hPrevInstance,
                      LPSTR     lpCmdLine,
                      int       nCmdShow)
{
// Initialize Windows

    // If we are already running, this routine will reactivate the older
    // application and return failure.
    if (!InitApplication (hInstance, nCmdShow, 320, 240))
        return 1;

    IvorySystem ivory;

// Create turner instance 
    Net = new TurnerTest(TEST_GUID,"Turner Tester", 4);

// Create user interface 
    NetUI = new TurnerNetworkUI(hWndClient,Net);
    if (!NetUI->connect())
    {
        MessageBox(hWndClient,"Connect failed",szAppName,MB_OK);
    }
    else
    {
        dword   len;
        char    name[256];
        char    desc[256];

        len=255;
        GetUserName(name,&len);

        len=255;
        GetComputerName(desc,&len);

        Net->create_player(name,desc);
    }

// Main Loop
    while (PumpWindows());

// Cleanup
    delete NetUI;
    delete Net;

    return 0;
}


//
// PumpWindows
//
BOOL PumpWindows()
{
    MSG msg;
    while (PeekMessage (&msg, NULL, 0, 0, PM_NOREMOVE))
    {
        if (GetMessage (&msg, 0, 0, 0) == 0)
            return FALSE;

        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }

    return TRUE;
}


//
// ClientWndProc
//
LRESULT CALLBACK ClientWndProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    static shift = 0;
    static ctrl = 0;

    switch (message)
    {
        // Keyboard Events
        case WM_KEYDOWN:
            switch (wParam)
            {
                case VK_ESCAPE:
                    DestroyWindow(hWndClient);
                    break;
                case VK_SHIFT:
                    shift=1;
                    break;
                case VK_CONTROL:
                    ctrl=1;
                    break;
                case '1':

                    break;
                case 'S':

                    break;
            }
            return 0;

        case WM_KEYUP:
            switch (wParam)
            {
                case VK_SHIFT:
                    shift=0;
                    break;
                case VK_CONTROL:
                    ctrl=0;
                    break;
            }
            return 0;

        // Application Events
        case WM_CREATE:
            return 0;

        case WM_CLOSE:
            DestroyWindow(hWndClient);
            return 0;

        case WM_DESTROY:
            PostQuitMessage (0);
            return 0;

        default:
            return DefWindowProc (hWnd, message, wParam, lParam);
    }
}


//
// TurnerNet::handle_msg
//
void TurnerTest::handle_msg (DPID from, DPID to, LPVOID ptr, DWORD size)
{
    char buff[1024];
    wsprintf(buff,"Msg from %x to %x of size %d\n",from,to,size);
    MessageBox(hWndClient,buff,"handle_msg", MB_OK);
}


//
// TurnerNet::handle_chat
//
void TurnerTest::handle_chat (DPID fromplayer, DPID toplayer, DPID togroup, LPSTR msg)
{
    char buff[1024];
    wsprintf(buff,"Chat from %x to %x/%x: %s\n",fromplayer,toplayer,togroup,msg);
    MessageBox(hWndClient,buff,"handle_chat", MB_OK);
}


//
// str_error
//
char *str_error(char *str, int res)
{
    switch (res)
    {
        case DPERR_GENERIC:
            strcpy(str,"generic");
            break;
        case DPERR_INVALIDPARAMS:
            strcpy(str,"invalidparams");
            break;
        case DPERR_UNAVAILABLE:
            strcpy(str,"unavailable");
            break;
        default:
            wsprintf(str,"Error %d",res);
            break;
    }
    return str;
}


//
// Windows Initialization Functions 
//

//
// InitApplication
//
BOOL InitApplication (HINSTANCE hInstance, int nCmdShow, int w, int h)
{
// Win32 will always set hPrevInstance to NULL, so lets check
// things a little closer. This is because we only want a single
// version of this app to run at a time
    HWND hwnd = FindWindow (szAppName, NULL);
    if (hwnd != 0)
    {
        // We found another version of ourself. Lets defer to it:
        if (IsIconic (hwnd))
            ShowWindow (hwnd, SW_RESTORE);
        SetForegroundWindow (hwnd);
        return FALSE;
    }

// Register the client window's class
    WNDCLASSEX  wc;

    // Fill in window class structure with parameters that describe
    // the main window.
    wc.cbSize        = sizeof (WNDCLASSEX);
    wc.style         = CS_OWNDC;
    wc.lpfnWndProc   = (WNDPROC)ClientWndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInstance;
    wc.hIcon         = LoadIcon (hInstance, szAppName);
    wc.hCursor       = LoadCursor (NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)GetStockObject (BLACK_BRUSH);
    wc.lpszClassName = szAppName;
    wc.lpszMenuName  = 0;

    // This will load the small icon image from the icon resource
    wc.hIconSm = (HICON__*)LoadImage (hInstance,
                                      szAppName,
                                      IMAGE_ICON,
                                      GetSystemMetrics(SM_CXSMICON),
                                      GetSystemMetrics(SM_CYSMICON),
                                      LR_DEFAULTCOLOR);

    if (!RegisterClassEx (&wc))
        return FALSE;

    // Save the instance handle in static variable, which will be used in
    // many subsequence calls from this application to Windows.
    hInst = hInstance;

    hWndClient = CreateWindowEx (0,
                                 szAppName, szAppName,
                                 WS_OVERLAPPEDWINDOW | WS_VISIBLE,
                                 0, 0, w, h,
                                 NULL, NULL, hInstance, NULL);

    if (hWndClient == 0)
        return FALSE;

    ShowWindow (hWndClient, nCmdShow);
    UpdateWindow (hWndClient);
    SetFocus (hWndClient);

    return TRUE;
}


//
// MythOS Assert Display 
//

//
// _charybdis_assert
//
// Handler for failed asserts.  If msg is set to non-NULL, then an assertMyth
// was used with a comment.
//
extern "C" void _charybdis_assert(char *msg, char *exp, char *f, unsigned ln)
{
    cout.flush();
    printf("\n\n Assertion Failed \n"
           "Expr:\t%s\n"
           "File:\t%s\t\tLine %d\n",exp,f,ln);
    if (msg)
    {
        printf("Comment:\n%s\n",msg);
    }

    exit(1);
}

// A support function (usually provided by MythosSystem)
extern "C" int mythos_atexit( register void ( *__func )( void ) )
{
    return atexit (__func);
}

// Make sure it uses the correct calling convention!
#ifdef __WATCOMC__
#pragma aux (_ASMSTKCALL_) mythos_atexit;
#endif

// End of module - turner.cpp 
